/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.util.DataManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public abstract class DataManagerSyncPacket<T> {
    private Map<ResourceLocation, T> elements = Collections.emptyMap();

    public DataManagerSyncPacket<T> with(Map<ResourceLocation, T> elements) {
        this.elements = elements;
        return this;
    }

    public void encode(DataManager<T> manager, FriendlyByteBuf buffer) {
        buffer.m_130130_(this.elements.size());
        for (Map.Entry<ResourceLocation, T> entry : this.elements.entrySet()) {
            buffer.m_130085_(entry.getKey());
            manager.rawToNetwork(buffer, entry.getValue());
        }
    }

    public void decode(DataManager<T> manager, FriendlyByteBuf buffer) {
        this.elements = new HashMap<ResourceLocation, T>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            T element = manager.rawFromNetwork(id, buffer);
            this.elements.put(id, element);
        }
    }

    public void handle(NetworkEvent.Context context, DataManager<T> manager) {
        manager.onSync(context, this.elements);
    }
}

