/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KnappingRecipeCategory<T extends KnappingRecipe>
extends BaseRecipeCategory<T> {
    @Nullable
    private final IDrawable high;
    @Nullable
    private final IDrawable low;

    public KnappingRecipeCategory(RecipeType<T> type, IGuiHelper helper, ItemStack icon, @Nullable ResourceLocation high, @Nullable ResourceLocation low) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(135, 82), icon);
        this.high = high == null ? null : helper.drawableBuilder(high, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.low = low == null ? null : helper.drawableBuilder(low, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlots, PoseStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 86, 33);
        this.arrowAnimated.draw(stack, 86, 33);
        IDrawable high = this.getHigh(recipe, recipeSlots);
        IDrawable low = this.getLow(recipe, recipeSlots);
        int height = ((KnappingRecipe)recipe).getPattern().getHeight();
        int width = ((KnappingRecipe)recipe).getPattern().getWidth();
        boolean osr = ((KnappingRecipe)recipe).getPattern().isOutsideSlotRequired();
        int offsetX = Math.floorDiv(5 - width, 2);
        int offsetY = Math.floorDiv(5 - height, 2);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int yd = y - offsetY;
                int xd = x - offsetX;
                if (0 <= yd && yd < height && 0 <= xd && xd < width) {
                    if (((KnappingRecipe)recipe).getPattern().get(xd, yd)) {
                        if (high == null) continue;
                        high.draw(stack, 1 + x * 16, 1 + y * 16);
                        continue;
                    }
                    if (low == null) continue;
                    low.draw(stack, 1 + x * 16, 1 + y * 16);
                    continue;
                }
                if (osr) {
                    if (high == null) continue;
                    high.draw(stack, 1 + x * 16, 1 + y * 16);
                    continue;
                }
                if (low == null) continue;
                low.draw(stack, 1 + x * 16, 1 + y * 16);
            }
        }
    }

    @Nullable
    public IDrawable getHigh(T recipe, IRecipeSlotsView recipeSlots) {
        return this.high;
    }

    @Nullable
    public IDrawable getLow(T recipe, IRecipeSlotsView recipeSlots) {
        return this.low;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 33);
        outputSlot.addItemStack(((KnappingRecipe)recipe).m_8043_());
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
    }
}

