/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jade.common;

import java.util.function.BiConsumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.TFCFishingHook;
import net.dries007.tfc.common.entities.WildAnimal;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.compat.jade.common.EntityTooltip;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class EntityTooltips {
    public static final EntityTooltip ANIMAL = (level, entity, tooltip) -> {
        MammalProperties mammal;
        GenderedRenderAnimal animal;
        if (entity instanceof WildAnimal) {
            animal = (WildAnimal)entity;
            if (((WildAnimal)animal).displayMaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum(TFCAnimalProperties.Gender.MALE));
            } else if (((WildAnimal)animal).displayFemaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum(TFCAnimalProperties.Gender.FEMALE));
            }
            if (((WildAnimal)animal).m_6162_()) {
                tooltip.accept(Helpers.translatable("tfc.jade.juvenile"));
            }
        }
        if (entity instanceof TFCAnimalProperties) {
            animal = (TFCAnimalProperties)entity;
            TranslatableComponent line1 = Helpers.translateEnum(animal.getGender());
            if (animal.isFertilized()) {
                line1.m_130946_(", ").m_7220_((Component)Helpers.translatable("tfc.tooltip.fertilized"));
            }
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            TFCAnimalProperties.Age age = animal.getAgeType();
            ChatFormatting familiarityStyle = ChatFormatting.GRAY;
            if (familiarity >= animal.getAdultFamiliarityCap() && age != TFCAnimalProperties.Age.CHILD) {
                familiarityStyle = ChatFormatting.RED;
            } else if (familiarity > 0.3f) {
                familiarityStyle = ChatFormatting.WHITE;
            }
            line1.m_130946_(", ").m_7220_((Component)Helpers.translatable("tfc.jade.familiarity", familiarityPercent).m_130940_(familiarityStyle));
            tooltip.accept(line1);
            tooltip.accept(Helpers.translatable("tfc.jade.animal_size", animal.getGeneticSize()));
            if (animal.isReadyForAnimalProduct()) {
                tooltip.accept(animal.getProductReadyName().m_130940_(ChatFormatting.GREEN));
            }
            if (animal.isReadyToMate()) {
                tooltip.accept(Helpers.translatable("tfc.jade.can_mate"));
            }
            double usageRatio = animal.getUses() >= animal.getUsesToElderly() ? 0.99 : (double)((float)animal.getUses() / (float)animal.getUsesToElderly());
            switch (age) {
                case CHILD: {
                    tooltip.accept(Helpers.translatable("tfc.jade.adulthood_progress", Calendars.get((LevelReader)level).getTimeDelta(24000L * ((long)animal.getDaysToAdulthood() + animal.getBirthDay() - Calendars.get((LevelReader)level).getTotalDays()))));
                    break;
                }
                case ADULT: {
                    tooltip.accept(Helpers.translatable("tfc.jade.animal_wear", String.format("%d%%", Math.min(100L, Math.round(100.0 * usageRatio)))));
                    break;
                }
                case OLD: {
                    tooltip.accept(Helpers.translatable("tfc.jade.old_animal"));
                }
            }
        }
        if (entity instanceof MammalProperties && (mammal = (MammalProperties)entity).getPregnantTime() > 0L) {
            tooltip.accept(Helpers.translatable("tfc.tooltip.animal.pregnant", entity.m_7755_().getString()));
            ICalendar calendar = Calendars.get((LevelReader)level);
            tooltip.accept(Helpers.translatable("tfc.jade.gestation_time_left", calendar.getTimeDelta(24000L * (mammal.getGestationDays() + mammal.getPregnantTime() - Calendars.get((LevelReader)level).getTotalDays()))));
        }
        if (entity instanceof HorseProperties) {
            TFCChestedHorse chested;
            HorseProperties horse = (HorseProperties)entity;
            if (horse.getFamiliarity() >= 0.15f) {
                tooltip.accept(Helpers.translatable("tfc.jade.may_ride_horse"));
            }
            if (entity instanceof TFCHorse) {
                TFCHorse tfcHorse = (TFCHorse)entity;
                tooltip.accept(Helpers.translatable("tfc.jade.variant_and_markings", Helpers.translateEnum(tfcHorse.m_30723_()), Helpers.translateEnum(tfcHorse.m_30724_())));
            }
            if (entity instanceof TFCChestedHorse && !(chested = (TFCChestedHorse)entity).getChestItem().m_41619_()) {
                MutableComponent component = chested.getChestItem().m_41786_().m_6881_();
                chested.getChestItem().getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0)).filter(f -> !f.isEmpty()).ifPresent(fluid -> component.m_130946_(", ").m_7220_((Component)Tooltips.fluidUnitsOf(fluid)));
                tooltip.accept(component);
            }
        }
    };
    public static final EntityTooltip PACK_PREDATOR = (level, entity, tooltip) -> {
        if (entity instanceof PackPredator) {
            PackPredator predator = (PackPredator)entity;
            tooltip.accept(Helpers.translatable("tfc.jade.pack_respect", predator.getRespect()));
            if (predator.isTamable()) {
                String familiarityPercent = String.format("%.2f", Float.valueOf(predator.getFamiliarity() * 100.0f));
                tooltip.accept(Helpers.translatable("tfc.jade.familiarity", familiarityPercent));
            }
        }
    };
    public static final EntityTooltip OCELOT = (level, entity, tooltip) -> {
        if (entity instanceof TFCOcelot) {
            TFCOcelot ocelot = (TFCOcelot)entity;
            String familiarityPercent = String.format("%.2f", Float.valueOf(ocelot.getFamiliarity() * 100.0f));
            tooltip.accept(Helpers.translatable("tfc.jade.familiarity", familiarityPercent));
        }
    };
    public static final EntityTooltip SQUID = (level, entity, tooltip) -> {
        if (entity instanceof TFCSquid) {
            TFCSquid squid = (TFCSquid)entity;
            tooltip.accept(Helpers.translatable("tfc.jade.squid_size", squid.getSize()));
        }
    };
    public static final EntityTooltip FISH = (level, entity, tooltip) -> {
        if (entity instanceof AquaticMob) {
            AquaticMob aquatic = (AquaticMob)entity;
            if (aquatic.canSpawnIn((Fluid)TFCFluids.SALT_WATER.getSource())) {
                tooltip.accept(Helpers.translatable("tfc.jade.saltwater"));
            }
            if (aquatic.canSpawnIn((Fluid)Fluids.f_76193_)) {
                tooltip.accept(Helpers.translatable("tfc.jade.freshwater"));
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.NEEDS_LARGE_FISHING_BAIT)) {
                tooltip.accept(Helpers.translatable("tfc.jade.large_bait"));
            }
        }
    };
    public static final EntityTooltip PREDATOR = (level, entity, tooltip) -> {
        if (entity instanceof Predator) {
            Predator predator = (Predator)entity;
            tooltip.accept(predator.isDiurnal() ? Helpers.translatable("tfc.jade.diurnal") : Helpers.translatable("tfc.jade.nocturnal"));
        }
    };
    public static final EntityTooltip RABBIT = (level, entity, tooltip) -> {
        Rabbit rabbit;
        int type;
        if (entity instanceof Rabbit && ((type = (rabbit = (Rabbit)entity).m_29719_()) >= 0 && type <= 5 || type == 99)) {
            tooltip.accept(Helpers.translatable("tfc.rabbit_" + type));
        }
    };
    public static final EntityTooltip HOOK = (level, entity, tooltip) -> {
        if (entity instanceof TFCFishingHook) {
            TFCFishingHook hook = (TFCFishingHook)entity;
            if (hook.m_37170_() != null) {
                tooltip.accept(Helpers.translatable("tfc.jade.hooked", hook.m_37170_().m_7755_()));
            }
            if (!hook.getBait().m_41619_()) {
                tooltip.accept(Helpers.translatable("tfc.jade.bait", hook.getBait().m_41786_()));
            }
        }
    };

    public static void register(BiConsumer<EntityTooltip, Class<? extends Entity>> registry) {
        registry.accept(ANIMAL, TFCAnimal.class);
        registry.accept(ANIMAL, TFCHorse.class);
        registry.accept(ANIMAL, TFCChestedHorse.class);
        registry.accept(ANIMAL, WildAnimal.class);
        registry.accept(SQUID, TFCSquid.class);
        registry.accept(FISH, WaterAnimal.class);
        registry.accept(PREDATOR, Predator.class);
        registry.accept(PACK_PREDATOR, PackPredator.class);
        registry.accept(OCELOT, TFCOcelot.class);
        registry.accept(RABBIT, Rabbit.class);
        registry.accept(HOOK, TFCFishingHook.class);
    }
}

