/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jade.common;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.TFCTorchBlock;
import net.dries007.tfc.common.blocks.TFCWallTorchBlock;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DecayingBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.DryingBricksBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.NestBoxBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockEntityTooltips {
    public static final BlockEntityTooltip INGOT_PILE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)entity;
            pile.fillTooltip(tooltip);
        }
    };
    public static final BlockEntityTooltip SHEET_PILE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof SheetPileBlockEntity) {
            SheetPileBlockEntity pile = (SheetPileBlockEntity)entity;
            pile.fillTooltip(tooltip);
        }
    };
    public static final BlockEntityTooltip BARREL = (level, state, pos, entity, tooltip) -> {
        if (state.m_60734_() instanceof BarrelBlock && entity instanceof BarrelBlockEntity) {
            BarrelRecipe recipe;
            BarrelBlockEntity barrel = (BarrelBlockEntity)entity;
            if (((Boolean)state.m_61143_((Property)BarrelBlock.SEALED)).booleanValue() && (recipe = barrel.getRecipe()) != null) {
                tooltip.accept(recipe.getTranslationComponent());
                tooltip.accept(Helpers.translatable("tfc.jade.sealed_date", ICalendar.getTimeAndDate(Calendars.get((LevelReader)level).ticksToCalendarTicks(barrel.getSealedTick()), Calendars.get((LevelReader)level).getCalendarDaysInMonth())));
                if (recipe instanceof SealedBarrelRecipe) {
                    SealedBarrelRecipe sealedRecipe = (SealedBarrelRecipe)recipe;
                    BlockEntityTooltips.timeLeft(level, tooltip, (long)sealedRecipe.getDuration() - (Calendars.get((LevelReader)level).getTicks() - barrel.getRecipeTick()));
                }
            }
        }
    };
    public static final BlockEntityTooltip BELLOWS = (level, state, pos, entity, tooltip) -> {
        BellowsBlockEntity bellows;
        int pushTicks;
        if (entity instanceof BellowsBlockEntity && (pushTicks = (bellows = (BellowsBlockEntity)entity).getTicksSincePushed()) < 20 && pushTicks > 0) {
            if (pushTicks > 10) {
                pushTicks = 20 - pushTicks;
            }
            tooltip.accept(Helpers.translatable("tfc.jade.bellows_" + pushTicks));
        }
    };
    public static final BlockEntityTooltip BLAST_FURNACE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BlastFurnaceBlockEntity) {
            BlastFurnaceBlockEntity furnace = (BlastFurnaceBlockEntity)entity;
            furnace.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> BlockEntityTooltips.heat(tooltip, cap.getTemperature()));
            tooltip.accept(Helpers.translatable("tfc.jade.input_stacks", furnace.getInputCount()));
            tooltip.accept(Helpers.translatable("tfc.jade.catalyst_stacks", furnace.getCatalystCount()));
            tooltip.accept(Helpers.translatable("tfc.jade.fuel_stacks", furnace.getFuelCount()));
        }
    };
    public static final BlockEntityTooltip BLOOMERY = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomeryBlockEntity) {
            BloomeryBlockEntity bloomery = (BloomeryBlockEntity)entity;
            if (state.m_60734_() instanceof BloomeryBlock) {
                BloomeryRecipe recipe;
                long ticksLeft;
                tooltip.accept(Helpers.translatable("tfc.jade.input_stacks", bloomery.getInputStacks().size()));
                tooltip.accept(Helpers.translatable("tfc.jade.catalyst_stacks", bloomery.getCatalystStacks().size()));
                if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue() && (ticksLeft = bloomery.getRemainingTicks()) > 0L && (recipe = bloomery.getCachedRecipe()) != null) {
                    BlockEntityTooltips.timeLeft(level, tooltip, ticksLeft);
                    tooltip.accept(Helpers.translatable("tfc.jade.creating", recipe.m_8043_().m_41786_()));
                }
            }
        }
    };
    public static final BlockEntityTooltip BLOOM = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomBlockEntity) {
            BloomBlockEntity bloom = (BloomBlockEntity)entity;
            ItemStack item = bloom.getItem();
            ItemStack displayItem = item.m_41777_();
            displayItem.m_41764_(bloom.getCount());
            BlockEntityTooltips.itemWithCount(tooltip, displayItem);
            ArrayList text = new ArrayList();
            item.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(item, text));
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip CHARCOAL_FORGE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CharcoalForgeBlockEntity) {
            CharcoalForgeBlockEntity forge = (CharcoalForgeBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, forge.getTemperature());
        }
    };
    public static final BlockEntityTooltip COMPOSTER = (level, state, pos, entity, tooltip) -> {
        Block patt9042$temp = state.m_60734_();
        if (patt9042$temp instanceof TFCComposterBlock) {
            TFCComposterBlock block = (TFCComposterBlock)patt9042$temp;
            if (entity instanceof ComposterBlockEntity) {
                ComposterBlockEntity composter = (ComposterBlockEntity)entity;
                if (composter.isRotten()) {
                    tooltip.accept(Helpers.translatable("tfc.composter.rotten"));
                } else if (!composter.isReady() && (Integer)state.m_61143_((Property)TFCComposterBlock.STAGE) == 8) {
                    BlockEntityTooltips.timeLeft(level, tooltip, composter.getReadyTicks() - composter.getTicksSinceUpdate());
                }
            }
        }
    };
    public static final BlockEntityTooltip CROP = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CropBlockEntity) {
            CropBlockEntity crop = (CropBlockEntity)entity;
            Block patt9743$temp = state.m_60734_();
            if (patt9743$temp instanceof CropBlock) {
                CropBlock block = (CropBlock)patt9743$temp;
                tooltip.accept(Helpers.translatable("tfc.jade.yield", String.format("%.0f", Float.valueOf(crop.getYield() * 100.0f))));
            }
        }
    };
    public static final BlockEntityTooltip CRUCIBLE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)entity;
            crucible.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> BlockEntityTooltips.heat(tooltip, cap.getTemperature()));
        }
    };
    public static final BlockEntityTooltip FIREPIT = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity firepit = (AbstractFirepitBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, firepit.getTemperature());
            if (state.m_61138_((Property)FirepitBlock.SMOKE_LEVEL)) {
                tooltip.accept(Helpers.translatable("tfc.jade.smoke_level", state.m_61143_((Property)FirepitBlock.SMOKE_LEVEL)));
            }
            if (firepit instanceof PotBlockEntity) {
                PotBlockEntity pot = (PotBlockEntity)firepit;
                if (pot.shouldRenderAsBoiling()) {
                    tooltip.accept(Helpers.translatable("tfc.tooltip.pot_boiling"));
                } else if (pot.getOutput() != null && !pot.getOutput().isEmpty()) {
                    tooltip.accept(Helpers.translatable("tfc.tooltip.pot_finished"));
                    PotRecipe.Output patt11121$temp = pot.getOutput();
                    if (patt11121$temp instanceof SoupPotRecipe.SoupOutput) {
                        SoupPotRecipe.SoupOutput soup = (SoupPotRecipe.SoupOutput)patt11121$temp;
                        ItemStack stack = soup.stack();
                        BlockEntityTooltips.itemWithCount(tooltip, stack);
                        ArrayList text = new ArrayList();
                        stack.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(stack, text));
                        text.forEach(tooltip);
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip FRUIT_TREE_SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            Block patt11803$temp = state.m_60734_();
            if (patt11803$temp instanceof FruitTreeSaplingBlock) {
                FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)patt11803$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((double)(sapling.getTreeGrowthDays() * 24000) * (Double)TFCConfig.SERVER.globalFruitSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate(), (Component)Helpers.translatable("tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip HOE_OVERLAY = (level, state, pos, entity, tooltip) -> {
        Block patt12240$temp = state.m_60734_();
        if (patt12240$temp instanceof HoeOverlayBlock) {
            HoeOverlayBlock overlay = (HoeOverlayBlock)patt12240$temp;
            if (((Boolean)TFCConfig.CLIENT.showHoeOverlaysInInfoMods.get()).booleanValue() && entity != null) {
                ArrayList<Component> text = new ArrayList<Component>();
                BlockPos pos1 = entity.m_58899_();
                overlay.addHoeOverlayInfo(level, pos1, level.m_8055_(pos1), text, false);
                text.forEach(tooltip);
            }
        }
    };
    public static final BlockEntityTooltip LAMP = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof LampBlockEntity) {
            LampFuel fuel;
            LampBlockEntity lamp = (LampBlockEntity)entity;
            if (state.m_60734_() instanceof LampBlock && (fuel = lamp.getFuel()) != null) {
                if (fuel.getBurnRate() != -1) {
                    tooltip.accept(Helpers.translatable("tfc.jade.burn_rate", fuel.getBurnRate()));
                }
                if (((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
                    if (fuel.getBurnRate() == -1) {
                        tooltip.accept(Helpers.translatable("tfc.jade.burn_forever"));
                    } else {
                        lamp.getCapability(Capabilities.FLUID).ifPresent(cap -> {
                            int fluid = cap.getFluidInTank(0).getAmount();
                            if (fluid > 0) {
                                BlockEntityTooltips.timeLeft(level, tooltip, (long)fluid * (long)fuel.getBurnRate());
                            }
                        });
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip NEST_BOX = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof NestBoxBlockEntity) {
            NestBoxBlockEntity nest = (NestBoxBlockEntity)entity;
            ArrayList text = new ArrayList();
            nest.getCapability(Capabilities.ITEM).ifPresent(inventory -> {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    stack.getCapability(EggCapability.CAPABILITY).filter(IEgg::isFertilized).ifPresent(egg -> {
                        text.add(stack.m_41786_());
                        egg.addTooltipInfo(text);
                    });
                }
            });
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip PIT_KILN_INTERNAL = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos, tooltip);
    public static final BlockEntityTooltip PIT_KILN_ABOVE = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos.m_7495_(), tooltip);
    public static final BlockEntityTooltip POWDER_KEG = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof PowderkegBlockEntity) {
            PowderkegBlockEntity keg = (PowderkegBlockEntity)entity;
            tooltip.accept(Helpers.translatable("tfc.jade.explosion_strength", PowderkegBlockEntity.getStrength(keg)));
        }
    };
    public static final BlockEntityTooltip SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            Block patt15486$temp = state.m_60734_();
            if (patt15486$temp instanceof TFCSaplingBlock) {
                TFCSaplingBlock sapling = (TFCSaplingBlock)patt15486$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((double)(sapling.getDaysToGrow() * 24000) * (Double)TFCConfig.SERVER.globalSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate(), (Component)Helpers.translatable("tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip TORCH = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.torchTicks);
    public static final BlockEntityTooltip CANDLE = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.candleTicks);
    public static final BlockEntityTooltip JACK_O_LANTERN = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.jackOLanternTicks);
    public static final BlockEntityTooltip MUD_BRICKS = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            if (state.m_60734_() instanceof DryingBricksBlock) {
                if (((Boolean)state.m_61143_((Property)DryingBricksBlock.DRIED)).booleanValue()) {
                    tooltip.accept(Helpers.translatable("tfc.jade.dried_mud_bricks"));
                } else if (level.m_46758_(entity.m_58899_().m_7494_())) {
                    tooltip.accept(Helpers.translatable("tfc.jade.raining_mud_bricks").m_130940_(ChatFormatting.BLUE));
                } else {
                    BlockEntityTooltips.timeLeft(level, tooltip, (long)((Integer)TFCConfig.SERVER.mudBricksTicks.get()).intValue() - counter.getTicksSinceUpdate(), (Component)Helpers.translatable("tfc.jade.mud_bricks_nearly_done"));
                }
            }
        }
    };
    public static final BlockEntityTooltip DECAYING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)entity;
            ItemStack stack = decaying.getStack();
            tooltip.accept(stack.m_41786_());
            ArrayList text = new ArrayList();
            stack.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(stack, text));
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip LOOM = (level, state, pos, entity, tooltip) -> {
        LoomBlockEntity loom;
        LoomRecipe recipe;
        if (entity instanceof LoomBlockEntity && (recipe = (loom = (LoomBlockEntity)entity).getRecipe()) != null) {
            tooltip.accept(Helpers.translatable("tfc.jade.loom_progress", loom.getProgress(), recipe.getStepCount(), recipe.m_8043_().m_41611_()));
        }
    };

    public static void register(BiConsumer<BlockEntityTooltip, Class<? extends Block>> registerBlock) {
        registerBlock.accept(BARREL, BarrelBlock.class);
        registerBlock.accept(BELLOWS, BellowsBlock.class);
        registerBlock.accept(SAPLING, TFCSaplingBlock.class);
        registerBlock.accept(BLAST_FURNACE, BlastFurnaceBlock.class);
        registerBlock.accept(BLOOMERY, BloomeryBlock.class);
        registerBlock.accept(BLOOM, BloomBlock.class);
        registerBlock.accept(CHARCOAL_FORGE, CharcoalForgeBlock.class);
        registerBlock.accept(COMPOSTER, TFCComposterBlock.class);
        registerBlock.accept(CROP, CropBlock.class);
        registerBlock.accept(CRUCIBLE, CrucibleBlock.class);
        registerBlock.accept(FIREPIT, FirepitBlock.class);
        registerBlock.accept(FRUIT_TREE_SAPLING, FruitTreeSaplingBlock.class);
        registerBlock.accept(HOE_OVERLAY, Block.class);
        registerBlock.accept(LAMP, LampBlock.class);
        registerBlock.accept(NEST_BOX, NestBoxBlock.class);
        registerBlock.accept(PIT_KILN_INTERNAL, PitKilnBlock.class);
        registerBlock.accept(PIT_KILN_ABOVE, FireBlock.class);
        registerBlock.accept(POWDER_KEG, PowderkegBlock.class);
        registerBlock.accept(TORCH, TFCTorchBlock.class);
        registerBlock.accept(TORCH, TFCWallTorchBlock.class);
        registerBlock.accept(CANDLE, TFCCandleBlock.class);
        registerBlock.accept(CANDLE, TFCCandleCakeBlock.class);
        registerBlock.accept(JACK_O_LANTERN, JackOLanternBlock.class);
        registerBlock.accept(MUD_BRICKS, DryingBricksBlock.class);
        registerBlock.accept(DECAYING, DecayingBlock.class);
        registerBlock.accept(LOOM, TFCLoomBlock.class);
        registerBlock.accept(SHEET_PILE, SheetPileBlock.class);
        registerBlock.accept(INGOT_PILE, IngotPileBlock.class);
    }

    private static void pitKiln(Level level, BlockPos pos, Consumer<Component> tooltip) {
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PitKilnBlockEntity) {
            PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
            if (state.m_60734_() instanceof PitKilnBlock) {
                if ((Integer)state.m_61143_((Property)PitKilnBlock.STAGE) == 16) {
                    BlockEntityTooltips.timeLeft(level, tooltip, kiln.getTicksLeft());
                } else {
                    tooltip.accept((Component)Helpers.translatable("tfc.jade.straws", kiln.getStraws().stream().filter(s -> !s.m_41619_()).toList().size()));
                    tooltip.accept((Component)Helpers.translatable("tfc.jade.logs", kiln.getLogs().stream().filter(s -> !s.m_41619_()).toList().size()));
                }
            }
        }
    }

    public static void itemWithCount(Consumer<Component> tooltip, ItemStack stack) {
        tooltip.accept((Component)Helpers.literal(String.valueOf(stack.m_41613_())).m_130946_("x ").m_7220_(stack.m_41786_()));
    }

    public static void heat(Consumer<Component> tooltip, float temperature) {
        MutableComponent heat = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(temperature);
        if (heat != null) {
            tooltip.accept((Component)heat);
        }
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks) {
        BlockEntityTooltips.timeLeft(level, tooltip, ticks, null);
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks, @Nullable Component ifNegative) {
        if (ticks > 0L) {
            tooltip.accept((Component)Helpers.translatable("tfc.jade.time_left", Calendars.get((LevelReader)level).getTimeDelta(ticks)));
        } else if (ifNegative != null) {
            tooltip.accept(ifNegative);
        }
    }

    public static BlockEntityTooltip tickCounter(Supplier<Integer> totalTicks) {
        return (level, state, pos, entity, tooltip) -> {
            if (entity instanceof TickCounterBlockEntity) {
                TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((Integer)totalTicks.get()).intValue() - counter.getTicksSinceUpdate());
            }
        };
    }
}

