/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import net.dries007.tfc.common.recipes.outputs.AddBaitToRodModifier;
import net.dries007.tfc.common.recipes.outputs.AddHeatModifier;
import net.dries007.tfc.common.recipes.outputs.AddRemoveTraitModifier;
import net.dries007.tfc.common.recipes.outputs.CopyFoodModifier;
import net.dries007.tfc.common.recipes.outputs.CopyForgingBonusModifier;
import net.dries007.tfc.common.recipes.outputs.CopyHeatModifier;
import net.dries007.tfc.common.recipes.outputs.CopyInputModifier;
import net.dries007.tfc.common.recipes.outputs.CopyOldestFoodModifier;
import net.dries007.tfc.common.recipes.outputs.DyeLeatherModifier;
import net.dries007.tfc.common.recipes.outputs.EmptyBowlModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.MealModifier;
import net.dries007.tfc.common.recipes.outputs.ResetFoodModifier;
import net.dries007.tfc.common.recipes.outputs.SandwichModifier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ItemStackModifiers {
    private static final BiMap<ResourceLocation, ItemStackModifier.Serializer<?>> REGISTRY = HashBiMap.create();

    public static void registerItemStackModifierTypes() {
        ItemStackModifiers.register("copy_input", CopyInputModifier.INSTANCE);
        ItemStackModifiers.register("copy_food", CopyFoodModifier.INSTANCE);
        ItemStackModifiers.register("copy_oldest_food", CopyOldestFoodModifier.INSTANCE);
        ItemStackModifiers.register("copy_heat", CopyHeatModifier.INSTANCE);
        ItemStackModifiers.register("copy_forging_bonus", CopyForgingBonusModifier.INSTANCE);
        ItemStackModifiers.register("reset_food", ResetFoodModifier.INSTANCE);
        ItemStackModifiers.register("empty_bowl", EmptyBowlModifier.INSTANCE);
        ItemStackModifiers.register("add_bait_to_rod", AddBaitToRodModifier.INSTANCE);
        ItemStackModifiers.register("sandwich", SandwichModifier.INSTANCE);
        ItemStackModifiers.register("add_trait", AddRemoveTraitModifier.Serializer.ADD);
        ItemStackModifiers.register("remove_trait", AddRemoveTraitModifier.Serializer.REMOVE);
        ItemStackModifiers.register("add_heat", AddHeatModifier.Serializer.INSTANCE);
        ItemStackModifiers.register("dye_leather", DyeLeatherModifier.Serializer.INSTANCE);
        ItemStackModifiers.register("meal", MealModifier.Serializer.INSTANCE);
    }

    public static synchronized <V extends ItemStackModifier, T extends ItemStackModifier.Serializer<V>> T register(ResourceLocation key, T serializer) {
        if (REGISTRY.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        REGISTRY.put((Object)key, serializer);
        return serializer;
    }

    public static ItemStackModifier fromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String type = JsonHelpers.m_13805_((JsonElement)json, (String)"modifier");
            ItemStackModifier.Serializer<?> serializer = ItemStackModifiers.getSerializer(type);
            if (serializer instanceof ItemStackModifier.SingleInstance) {
                ItemStackModifier.SingleInstance factory = (ItemStackModifier.SingleInstance)serializer;
                return factory.instance();
            }
            throw new JsonParseException("Serializer type: " + type + " cannot be declared inline");
        }
        JsonObject obj = JsonHelpers.m_13918_((JsonElement)json, (String)"modifier");
        String type = JsonHelpers.m_13906_((JsonObject)obj, (String)"type");
        ItemStackModifier.Serializer<?> serializer = ItemStackModifiers.getSerializer(type);
        return serializer.fromJson(obj);
    }

    public static ItemStackModifier fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        ItemStackModifier.Serializer<?> serializer = ItemStackModifiers.byId(id);
        return serializer.fromNetwork(buffer);
    }

    public static ItemStackModifier.Serializer<?> byId(ResourceLocation id) {
        return Objects.requireNonNull((ItemStackModifier.Serializer)REGISTRY.get((Object)id), () -> "No serializer by id: " + id);
    }

    public static ResourceLocation getId(ItemStackModifier.Serializer<?> serializer) {
        return Objects.requireNonNull((ResourceLocation)REGISTRY.inverse().get(serializer), () -> "Unregistered serializer: " + serializer);
    }

    private static ItemStackModifier.Serializer<?> getSerializer(String type) {
        ItemStackModifier.Serializer serializer = (ItemStackModifier.Serializer)REGISTRY.get((Object)new ResourceLocation(type));
        if (serializer != null) {
            return serializer;
        }
        throw new JsonParseException("Unknown item stack modifier type: " + type);
    }

    private static void register(String name, ItemStackModifier.Serializer<?> serializer) {
        ItemStackModifiers.register(Helpers.identifier(name), serializer);
    }
}

