/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record AddHeatModifier(float temperature) implements ItemStackModifier
{
    @Override
    public ItemStack apply(ItemStack stack, ItemStack input) {
        stack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.setTemperature(cap.getTemperature() + this.temperature));
        return stack;
    }

    public Serializer serializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements ItemStackModifier.Serializer<AddHeatModifier>
    {
        INSTANCE;


        @Override
        public AddHeatModifier fromJson(JsonObject json) {
            float temperature = JsonHelpers.m_13915_((JsonObject)json, (String)"temperature");
            return new AddHeatModifier(temperature);
        }

        @Override
        public AddHeatModifier fromNetwork(FriendlyByteBuf buffer) {
            float temperature = buffer.readFloat();
            return new AddHeatModifier(temperature);
        }

        @Override
        public void toNetwork(AddHeatModifier modifier, FriendlyByteBuf buffer) {
            buffer.writeFloat(modifier.temperature);
        }
    }
}

