/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class NotRottenIngredient
extends DelegateIngredient {
    public static NotRottenIngredient of(Ingredient ingredient) {
        return new NotRottenIngredient(ingredient);
    }

    protected NotRottenIngredient(@Nullable Ingredient delegate) {
        super(delegate);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return super.test(stack) && stack != null && stack.getCapability(FoodCapability.CAPABILITY).map(cap -> !cap.isRotten()).orElse(false) != false;
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        return stack.getCapability(FoodCapability.CAPABILITY).map(food -> {
            food.setNonDecaying();
            return stack;
        }).orElse(null);
    }

    public static enum Serializer implements IIngredientSerializer<NotRottenIngredient>
    {
        INSTANCE;


        public NotRottenIngredient parse(JsonObject json) {
            Ingredient internal = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")) : null;
            return new NotRottenIngredient(internal);
        }

        public NotRottenIngredient parse(FriendlyByteBuf buffer) {
            return new NotRottenIngredient(Helpers.decodeNullable(buffer, Ingredient::m_43940_));
        }

        public void write(FriendlyByteBuf buffer, NotRottenIngredient ingredient) {
            Helpers.encodeNullable(ingredient.delegate, buffer, Ingredient::m_43923_);
        }
    }
}

