/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.common.recipes.ingredients.TraitIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class LacksTraitIngredient
extends TraitIngredient {
    public static LacksTraitIngredient of(@Nullable Ingredient delegate, FoodTrait trait) {
        return new LacksTraitIngredient(delegate, trait);
    }

    public static LacksTraitIngredient of(FoodTrait trait) {
        return new LacksTraitIngredient(null, trait);
    }

    public LacksTraitIngredient(@Nullable Ingredient delegate, FoodTrait trait) {
        super(delegate, trait);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return super.test(stack) && stack != null && stack.getCapability(FoodCapability.CAPABILITY).map(f -> !f.getTraits().contains(this.trait)).orElse(false) != false;
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return TraitIngredient.TraitSerializer.LACKS_TRAIT;
    }

    @Override
    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        return stack.getCapability(FoodCapability.CAPABILITY).resolve().map(food -> {
            food.setNonDecaying();
            if (food.getTraits().remove(this.trait)) {
                return null;
            }
            return stack;
        }).orElse(null);
    }
}

