/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Predicate;
import net.dries007.tfc.common.recipes.ingredients.FluidIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public record FluidStackIngredient(FluidIngredient ingredient, int amount) implements Predicate<FluidStack>
{
    public static final FluidStackIngredient EMPTY = new FluidStackIngredient(FluidIngredient.of(Fluids.f_76191_), 0);

    public static FluidStackIngredient fromJson(JsonObject json) {
        FluidIngredient fluid = FluidIngredient.fromJson(JsonHelpers.get(json, "ingredient"));
        int amount = JsonHelpers.m_13824_((JsonObject)json, (String)"amount", (int)1000);
        if (amount <= 0) {
            throw new JsonParseException("FluidStackIngredient 'amount' must be positive.");
        }
        return new FluidStackIngredient(fluid, amount);
    }

    public static FluidStackIngredient fromNetwork(FriendlyByteBuf buffer) {
        FluidIngredient fluid = FluidIngredient.fromNetwork(buffer);
        int amount = buffer.m_130242_();
        return new FluidStackIngredient(fluid, amount);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        FluidIngredient.toNetwork(buffer, this.ingredient);
        buffer.m_130130_(this.amount);
    }

    @Override
    public boolean test(FluidStack stack) {
        return stack.getAmount() >= this.amount && this.ingredient.test(stack.getFluid());
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.ingredient.toJson());
        json.addProperty("amount", (Number)this.amount);
        return json;
    }
}

