/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.SimpleBlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.TagBlockIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockIngredients {
    private static final BiMap<ResourceLocation, BlockIngredient.Serializer<?>> REGISTRY = HashBiMap.create();

    public static void registerBlockIngredientTypes() {
        BlockIngredients.register(Helpers.identifier("block"), SimpleBlockIngredient.Serializer.INSTANCE);
        BlockIngredients.register(Helpers.identifier("tag"), TagBlockIngredient.Serializer.INSTANCE);
    }

    public static synchronized <V extends BlockIngredient, T extends BlockIngredient.Serializer<V>> T register(ResourceLocation key, T serializer) {
        if (REGISTRY.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        REGISTRY.put((Object)key, serializer);
        return serializer;
    }

    public static BlockIngredient of(Block ... blocks) {
        return new SimpleBlockIngredient(Arrays.asList(blocks));
    }

    public static BlockIngredient of(TagKey<Block> tag) {
        return new TagBlockIngredient(tag);
    }

    public static BlockIngredient fromJson(JsonElement json) {
        BlockIngredient.Serializer<SimpleBlockIngredient> serializer;
        if (json.isJsonArray()) {
            return BlockIngredients.fromJsonArray(json.getAsJsonArray());
        }
        if (json.isJsonPrimitive()) {
            return BlockIngredients.fromJsonString(json.getAsString());
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("type")) {
            String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            serializer = (BlockIngredient.Serializer)REGISTRY.get((Object)new ResourceLocation(type));
            if (serializer == null) {
                throw new JsonParseException("Unknown block ingredient type: " + type);
            }
        } else if (obj.has("block")) {
            serializer = SimpleBlockIngredient.Serializer.INSTANCE;
        } else if (obj.has("tag")) {
            serializer = TagBlockIngredient.Serializer.INSTANCE;
        } else {
            throw new JsonParseException("Block ingredient must be either array, string, or object with either 'type', 'block', or 'tag' property");
        }
        return serializer.fromJson(obj);
    }

    public static SimpleBlockIngredient fromJsonArray(JsonArray array) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (JsonElement e : array) {
            blocks.add((Block)JsonHelpers.getRegistryEntry(e, ForgeRegistries.BLOCKS));
        }
        return new SimpleBlockIngredient(blocks);
    }

    public static SimpleBlockIngredient fromJsonString(String string) {
        return new SimpleBlockIngredient((Block)JsonHelpers.getRegistryEntry(string, ForgeRegistries.BLOCKS));
    }

    public static BlockIngredient fromNetwork(FriendlyByteBuf buffer) {
        BlockIngredient.Serializer serializer = (BlockIngredient.Serializer)REGISTRY.get((Object)buffer.m_130281_());
        return serializer.fromNetwork(buffer);
    }

    public static BlockIngredient.Serializer<?> byId(ResourceLocation id) {
        return Objects.requireNonNull((BlockIngredient.Serializer)REGISTRY.get((Object)id), () -> "No serializer by id: " + id);
    }

    public static ResourceLocation getId(BlockIngredient.Serializer<?> serializer) {
        return Objects.requireNonNull((ResourceLocation)REGISTRY.inverse().get(serializer), () -> "Unregistered serializer: " + serializer);
    }
}

