/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.ArrayList;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCFallingBlockEntity;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LandslideRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, LandslideRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().getValidBlocks(), TFCRecipeTypes.LANDSLIDE);

    @Nullable
    public static LandslideRecipe getRecipe(BlockState state) {
        for (LandslideRecipe recipe : CACHE.getAll(state.m_60734_())) {
            if (!recipe.matches(state)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean tryLandslide(Level level, BlockPos pos, BlockState state) {
        BlockPos fallPos;
        if (!level.m_5776_() && ((Boolean)TFCConfig.SERVER.enableBlockLandslides.get()).booleanValue() && (fallPos = LandslideRecipe.getLandslidePos(level, pos, state)) != null) {
            LandslideRecipe recipe = LandslideRecipe.getRecipe(state);
            if (recipe != null) {
                BlockState fallingState = recipe.getBlockCraftingResult(state);
                if (!fallPos.equals((Object)pos)) {
                    level.m_7471_(pos, false);
                    if (!FluidHelpers.isAirOrEmptyFluid(level.m_8055_(fallPos))) {
                        level.m_46961_(fallPos, true);
                    }
                }
                if (((Boolean)TFCConfig.SERVER.farmlandMakesTheBestRaceTracks.get()).booleanValue()) {
                    level.m_46597_(fallPos, fallingState);
                } else {
                    level.m_7731_(fallPos, fallingState, 18);
                }
                level.m_5594_(null, pos, (SoundEvent)TFCSounds.DIRT_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.4f, 1.0f);
                level.m_7967_((Entity)new TFCFallingBlockEntity(level, (double)fallPos.m_123341_() + 0.5, fallPos.m_123342_(), (double)fallPos.m_123343_() + 0.5, fallingState, 0.8f, 10));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockPos getLandslidePos(Level level, BlockPos pos, BlockState fallingState) {
        if (Support.isSupported((BlockGetter)level, pos)) {
            return null;
        }
        if (TFCFallingBlockEntity.canFallThrough((BlockGetter)level, pos.m_7495_(), Direction.DOWN, fallingState)) {
            return pos;
        }
        if (!LandslideRecipe.isSupportedOnSide((BlockGetter)level, pos, Direction.UP)) {
            int supportedDirections = 0;
            ArrayList<BlockPos> possibleDirections = new ArrayList<BlockPos>();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                if (LandslideRecipe.isSupportedOnSide((BlockGetter)level, pos, side)) {
                    if (++supportedDirections < 2) continue;
                    return null;
                }
                BlockPos posSide = pos.m_142300_(side);
                BlockPos posSideBelow = posSide.m_7495_();
                if (!TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posSide, side, fallingState) || !TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posSideBelow, Direction.DOWN)) continue;
                possibleDirections.add(posSide);
            }
            if (!possibleDirections.isEmpty()) {
                return (BlockPos)possibleDirections.get(level.m_5822_().nextInt(possibleDirections.size()));
            }
        }
        return null;
    }

    public static boolean isSupportedOnSide(BlockGetter world, BlockPos pos, Direction side) {
        BlockPos sidePos = pos.m_142300_(side);
        BlockState sideState = world.m_8055_(sidePos);
        return sideState.m_60783_(world, sidePos, side.m_122424_()) || Helpers.isBlock(sideState, TFCTags.Blocks.SUPPORTS_LANDSLIDE);
    }

    public LandslideRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean copyInputState) {
        super(id, ingredient, outputState, copyInputState);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.LANDSLIDE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.LANDSLIDE.get();
    }
}

