/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class InstantBarrelRecipe
extends BarrelRecipe {
    public InstantBarrelRecipe(ResourceLocation id, BarrelRecipe.Builder builder) {
        super(id, builder);
    }

    @Override
    public boolean matches(BarrelBlockEntity.BarrelInventory container, @Nullable Level level) {
        return super.matches(container, level) && (this.inputFluid.amount() == 0 || this.outputFluid.getAmount() == 0 || container.getFluidInTank(0).getAmount() / this.inputFluid.amount() <= container.getStackInSlot(2).m_41613_() / this.inputItem.count());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.INSTANT_BARREL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BARREL_INSTANT.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<InstantBarrelRecipe> {
        public InstantBarrelRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            BarrelRecipe.Builder builder = BarrelRecipe.Builder.fromJson(json);
            return new InstantBarrelRecipe(recipeId, builder);
        }

        @Nullable
        public InstantBarrelRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BarrelRecipe.Builder builder = BarrelRecipe.Builder.fromNetwork(buffer);
            return new InstantBarrelRecipe(recipeId, builder);
        }

        public void toNetwork(FriendlyByteBuf buffer, InstantBarrelRecipe recipe) {
            BarrelRecipe.Builder.toNetwork(recipe, buffer);
        }
    }
}

