/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FoodCombiningCraftingRecipe
extends CustomRecipe
implements ISimpleRecipe<CraftingContainer> {
    public FoodCombiningCraftingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean empty = true;
        ItemStack foodStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            empty = false;
            if (!stack.getCapability(FoodCapability.CAPABILITY).isPresent()) {
                return false;
            }
            if (foodStack.m_41619_()) {
                foodStack = stack;
                continue;
            }
            if (FoodCapability.areStacksStackableExceptCreationDate(stack, foodStack)) continue;
            return false;
        }
        return !empty;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack resultStack = ItemStack.f_41583_;
        int outputAmount = 0;
        long minCreationDate = -1L;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IFood cap2;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || (cap2 = (IFood)stack.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null)) == null) continue;
            ++outputAmount;
            if (minCreationDate == -1L || minCreationDate > cap2.getCreationDate()) {
                minCreationDate = cap2.getCreationDate();
            }
            if (!resultStack.m_41619_()) continue;
            resultStack = stack.m_41777_();
        }
        resultStack.m_41764_(outputAmount);
        long date = minCreationDate;
        resultStack.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.setCreationDate(date));
        return resultStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.FOOD_COMBINING_CRAFTING.get();
    }
}

