/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.recipes.DelegateRecipe;
import net.dries007.tfc.common.recipes.IRecipeDelegate;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public abstract class ExtraProductsCraftingRecipe<R extends Recipe<CraftingContainer>>
extends DelegateRecipe<R, CraftingContainer>
implements CraftingRecipe {
    private final List<ItemStack> extraProducts;

    protected ExtraProductsCraftingRecipe(ResourceLocation id, R recipe, List<ItemStack> extraProducts) {
        super(id, recipe);
        this.extraProducts = extraProducts;
    }

    public List<ItemStack> getExtraProducts() {
        return this.extraProducts;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        Player player = ForgeHooks.getCraftingPlayer();
        if (player != null) {
            this.extraProducts.forEach(item -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item.m_41777_()));
        }
        return super.m_7457_(inv);
    }

    public static class ExtraProductsSerializer
    extends RecipeSerializerImpl<ExtraProductsCraftingRecipe<?>> {
        private final TriFunction<ResourceLocation, Recipe<CraftingContainer>, List<ItemStack>, ExtraProductsCraftingRecipe<?>> factory;

        public static ExtraProductsSerializer shapeless(TriFunction<ResourceLocation, Recipe<CraftingContainer>, List<ItemStack>, ExtraProductsCraftingRecipe<?>> factory) {
            return new ExtraProductsSerializer((id, delegate, list) -> {
                if (delegate instanceof IShapedRecipe) {
                    throw new JsonParseException("Mixing shapeless delegate recipe type with shaped delegate, not allowed!");
                }
                return (ExtraProductsCraftingRecipe)factory.apply(id, delegate, list);
            });
        }

        public static ExtraProductsSerializer shaped(TriFunction<ResourceLocation, IShapedRecipe<CraftingContainer>, List<ItemStack>, ExtraProductsCraftingRecipe<?>> factory) {
            return new ExtraProductsSerializer((id, delegate, list) -> {
                if (!(delegate instanceof IShapedRecipe)) {
                    throw new JsonParseException("Mixing shaped delegate recipe type with shapeless delegate, not allowed!");
                }
                return (ExtraProductsCraftingRecipe)factory.apply(id, (Object)((IShapedRecipe)delegate), list);
            });
        }

        protected ExtraProductsSerializer(TriFunction<ResourceLocation, Recipe<CraftingContainer>, List<ItemStack>, ExtraProductsCraftingRecipe<?>> factory) {
            this.factory = factory;
        }

        public ExtraProductsCraftingRecipe<?> fromJson(ResourceLocation recipeID, JsonObject json) {
            return this.fromJson(recipeID, json, ICondition.IContext.EMPTY);
        }

        public ExtraProductsCraftingRecipe<?> fromJson(ResourceLocation recipeID, JsonObject json, ICondition.IContext context) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (JsonElement element : json.getAsJsonArray("extra_products")) {
                items.add(CraftingHelper.getItemStack((JsonObject)element.getAsJsonObject(), (boolean)true));
            }
            Recipe internal = RecipeManager.fromJson((ResourceLocation)DelegateRecipe.DELEGATE, (JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"recipe"), (ICondition.IContext)context);
            return (ExtraProductsCraftingRecipe)this.factory.apply((Object)recipeID, (Object)internal, items);
        }

        @Nullable
        public ExtraProductsCraftingRecipe<?> fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            ArrayList items = new ArrayList();
            Helpers.decodeAll(buffer, items, FriendlyByteBuf::m_130267_);
            Recipe internal = ClientboundUpdateRecipesPacket.m_133647_((FriendlyByteBuf)buffer);
            return (ExtraProductsCraftingRecipe)this.factory.apply((Object)recipeID, (Object)internal, items);
        }

        public void toNetwork(FriendlyByteBuf buffer, ExtraProductsCraftingRecipe<?> recipe) {
            Helpers.encodeAll(buffer, recipe.extraProducts, (item, buf) -> buf.m_130055_(item));
            ClientboundUpdateRecipesPacket.m_179469_((FriendlyByteBuf)buffer, recipe.getDelegate());
        }
    }

    public static class Shaped
    extends ExtraProductsCraftingRecipe<IShapedRecipe<CraftingContainer>>
    implements IRecipeDelegate.Shaped<CraftingContainer> {
        public Shaped(ResourceLocation id, IShapedRecipe<CraftingContainer> recipe, List<ItemStack> extraProducts) {
            super(id, recipe, extraProducts);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TFCRecipeSerializers.EXTRA_PRODUCTS_SHAPED_CRAFTING.get();
        }
    }

    public static class Shapeless
    extends ExtraProductsCraftingRecipe<Recipe<CraftingContainer>> {
        public Shapeless(ResourceLocation id, Recipe<CraftingContainer> recipe, List<ItemStack> extraProducts) {
            super(id, recipe, extraProducts);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TFCRecipeSerializers.EXTRA_PRODUCTS_SHAPELESS_CRAFTING.get();
        }
    }
}

