/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.inventory.BloomeryInventory;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BloomeryRecipe
implements ISimpleRecipe<BloomeryInventory> {
    private final ResourceLocation id;
    private final FluidStackIngredient inputFluid;
    private final Ingredient catalyst;
    private final ItemStackProvider result;
    private final int duration;

    @Nullable
    public static BloomeryRecipe get(Level level, ItemStack stack) {
        ItemStackInventory inventory = new ItemStackInventory(stack);
        HeatingRecipe heatRecipe = HeatingRecipe.getRecipe(inventory);
        if (heatRecipe != null) {
            FluidStack moltenFluid = heatRecipe.assembleFluid(inventory);
            for (BloomeryRecipe recipe : Helpers.getRecipes(level, TFCRecipeTypes.BLOOMERY).values()) {
                if (!recipe.inputFluid.ingredient().test(moltenFluid.getFluid())) continue;
                return recipe;
            }
        }
        return null;
    }

    public BloomeryRecipe(ResourceLocation id, FluidStackIngredient inputFluid, Ingredient catalyst, ItemStackProvider result, int duration) {
        this.id = id;
        this.inputFluid = inputFluid;
        this.catalyst = catalyst;
        this.result = result;
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    public boolean matches(BloomeryInventory inv, Level level) {
        return this.inputFluid.test(inv.getFluid()) && this.catalyst.test(inv.getCatalyst());
    }

    public boolean matchesInput(ItemStack stack) {
        ItemStackInventory inventory = new ItemStackInventory(stack);
        HeatingRecipe heat = HeatingRecipe.getRecipe(inventory);
        if (heat != null) {
            FluidStack fluid = heat.assembleFluid(inventory);
            return this.inputFluid.ingredient().test(fluid.getFluid());
        }
        return false;
    }

    public boolean matchesCatalyst(ItemStack stack) {
        return this.catalyst.test(stack);
    }

    public ItemStack m_8043_() {
        return this.result.getEmptyStack();
    }

    public ItemStack assemble(BloomeryInventory inventory) {
        ItemStack stack = this.result.getEmptyStack();
        stack.m_41764_(inventory.getFluid().getAmount() / this.inputFluid.amount());
        return stack;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.BLOOMERY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BLOOMERY.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<BloomeryRecipe> {
        public BloomeryRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStackIngredient fluidStack = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"fluid"));
            Ingredient catalyst = Ingredient.m_43917_((JsonElement)JsonHelpers.m_13930_((JsonObject)json, (String)"catalyst"));
            ItemStackProvider result = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int time = JsonHelpers.m_13927_((JsonObject)json, (String)"duration");
            return new BloomeryRecipe(recipeId, fluidStack, catalyst, result, time);
        }

        @Nullable
        public BloomeryRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidStackIngredient fluidStack = FluidStackIngredient.fromNetwork(buffer);
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            int time = buffer.m_130242_();
            return new BloomeryRecipe(recipeId, fluidStack, catalyst, result, time);
        }

        public void toNetwork(FriendlyByteBuf buffer, BloomeryRecipe recipe) {
            recipe.inputFluid.toNetwork(buffer);
            recipe.catalyst.m_43923_(buffer);
            recipe.result.toNetwork(buffer);
            buffer.m_130130_(recipe.duration);
        }
    }
}

