/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.AlloyInventory;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AlloyRecipe
implements ISimpleRecipe<AlloyInventory> {
    private final ResourceLocation id;
    private final java.util.function.Supplier<Map<Metal, Range>> metals;
    private final java.util.function.Supplier<Metal> result;

    public static Optional<AlloyRecipe> get(RecipeManager recipes, AlloyInventory inventory) {
        return recipes.m_44015_((RecipeType)TFCRecipeTypes.ALLOY.get(), (Container)inventory, null);
    }

    public AlloyRecipe(ResourceLocation id, java.util.function.Supplier<Map<Metal, Range>> metals, java.util.function.Supplier<Metal> result) {
        this.id = id;
        this.metals = metals;
        this.result = result;
    }

    public Map<Metal, Range> getRanges() {
        return this.metals.get();
    }

    public Metal getResult() {
        return this.result.get();
    }

    public boolean matches(AlloyInventory wrapper, @Nullable Level level) {
        return wrapper.getAlloy().matches(this);
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.ALLOY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.ALLOY.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AlloyRecipe> {
        public AlloyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Metal result = JsonHelpers.getFrom(json, "result", Metal.MANAGER);
            JsonArray contents = JsonHelpers.m_13933_((JsonObject)json, (String)"contents");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (JsonElement element : contents) {
                JsonObject content = JsonHelpers.m_13918_((JsonElement)element, (String)"entry in 'contents'");
                Metal metal = JsonHelpers.getFrom(content, "metal", Metal.MANAGER);
                double min = JsonHelpers.m_144784_((JsonObject)content, (String)"min");
                double max = JsonHelpers.m_144784_((JsonObject)content, (String)"max");
                builder.put((Object)metal, (Object)new Range(min, max));
            }
            ImmutableMap metals = builder.build();
            return new AlloyRecipe(recipeId, () -> Serializer.lambda$fromJson$0((Map)metals), () -> result);
        }

        @Nullable
        public AlloyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            HashMap<java.util.function.Supplier<Metal>, Range> metals = new HashMap<java.util.function.Supplier<Metal>, Range>();
            for (int i = 0; i < size; ++i) {
                java.util.function.Supplier<Metal> metal = Metal.MANAGER.fromNetwork(buffer);
                double min = buffer.readDouble();
                double max = buffer.readDouble();
                metals.put(metal, new Range(min, max));
            }
            Supplier lazyMetals = Suppliers.memoize(() -> metals.entrySet().stream().collect(Collectors.toMap(e -> (Metal)((java.util.function.Supplier)e.getKey()).get(), Map.Entry::getValue)));
            java.util.function.Supplier<Metal> result = Metal.MANAGER.fromNetwork(buffer);
            return new AlloyRecipe(recipeId, (java.util.function.Supplier<Map<Metal, Range>>)lazyMetals, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlloyRecipe recipe) {
            buffer.m_130130_(recipe.metals.get().size());
            recipe.metals.get().forEach((metal, range) -> {
                Metal.MANAGER.toNetwork((Metal)metal, buffer);
                buffer.writeDouble(range.min());
                buffer.writeDouble(range.max());
            });
            Metal.MANAGER.toNetwork(recipe.result.get(), buffer);
        }

        private static /* synthetic */ Map lambda$fromJson$0(Map metals) {
            return metals;
        }
    }

    public record Range(double min, double max) {
        public boolean isIn(double value, double epsilon) {
            return this.min - epsilon <= value && value <= this.max + epsilon;
        }
    }
}

