/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.fluids.Alcohol;
import net.dries007.tfc.common.fluids.SimpleFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Metal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;

public record FluidType(String name, OptionalInt color, Supplier<? extends Fluid> fluid) {
    public static final FluidType SALT_WATER = new FluidType("salt_water", OptionalInt.empty(), (Supplier<? extends Fluid>)TFCFluids.SALT_WATER.source());
    public static final FluidType SPRING_WATER = new FluidType("spring_water", OptionalInt.empty(), (Supplier<? extends Fluid>)TFCFluids.SPRING_WATER.source());
    private static final Map<Enum<?>, FluidType> IDENTITY = new HashMap();
    private static final List<FluidType> VALUES = Stream.of(Stream.of(SALT_WATER, SPRING_WATER), Arrays.stream(SimpleFluid.values()).map(fluid -> FluidType.fromEnum(fluid, fluid.getColor(), fluid.getId(), TFCFluids.SIMPLE_FLUIDS.get(fluid).source())), Arrays.stream(Alcohol.values()).map(fluid -> FluidType.fromEnum(fluid, fluid.getColor(), fluid.getId(), TFCFluids.ALCOHOLS.get(fluid).source())), Arrays.stream(DyeColor.values()).map(dye -> FluidType.fromEnum(dye, TFCFluids.dyeColorToInt(dye), dye.m_7912_() + "_dye", TFCFluids.COLORED_FLUIDS.get(dye).source())), Arrays.stream(Metal.Default.values()).map(metal -> FluidType.fromEnum(metal, metal.getColor(), "metal/" + metal.m_7912_(), TFCFluids.METALS.get(metal).source()))).flatMap(Function.identity()).toList();

    public static <R> Map<FluidType, R> mapOf(Function<? super FluidType, ? extends R> map) {
        return VALUES.stream().collect(Collectors.toMap(Function.identity(), map));
    }

    public static FluidType asType(Enum<?> identity) {
        return IDENTITY.get(identity);
    }

    private static FluidType fromEnum(Enum<?> identity, int color, String name, Supplier<? extends Fluid> fluid) {
        FluidType type = new FluidType(name, OptionalInt.of(0xFF000000 | color), fluid);
        IDENTITY.put(identity, type);
        return type;
    }
}

