/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.fluids.FlowingFluidRegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FluidProperty
extends Property<FluidKey> {
    private final Map<String, FluidKey> keysById;
    private final Map<Fluid, FluidKey> keysByFluid = new HashMap<Fluid, FluidKey>();
    private final List<FluidKey> keysByIndex;
    private final Lazy<Set<Fluid>> fluids;

    public static FluidProperty create(String name, Stream<Object> fluids) {
        return new FluidProperty(name, fluids.map(obj -> {
            if (obj instanceof ResourceLocation) {
                ResourceLocation id = (ResourceLocation)obj;
                return id;
            }
            if (obj instanceof Fluid) {
                Fluid fluid = (Fluid)obj;
                return fluid.getRegistryName();
            }
            if (obj instanceof RegistryObject) {
                RegistryObject reg = (RegistryObject)obj;
                return reg.getId();
            }
            if (obj instanceof FlowingFluidRegistryObject) {
                FlowingFluidRegistryObject pair = (FlowingFluidRegistryObject)obj;
                return pair.source().getId();
            }
            throw new IllegalArgumentException("FluidProperty#create called with a weird thing: " + obj);
        }));
    }

    protected FluidProperty(String name, Stream<ResourceLocation> fluids) {
        super(name, FluidKey.class);
        this.keysById = new HashMap<String, FluidKey>();
        this.keysByIndex = new ArrayList<FluidKey>();
        fluids.sorted().forEach(id -> {
            assert (!this.keysById.containsKey(id.m_135815_())) : "Duplicate fluid key: " + id.m_135815_();
            FluidKey key = new FluidKey((ResourceLocation)id);
            this.keysById.put(id.m_135815_(), key);
            this.keysByIndex.add(key);
        });
        this.fluids = Lazy.of(() -> this.keysByIndex.stream().map(FluidKey::getFluid).collect(Collectors.toSet()));
    }

    public boolean canContain(Fluid fluid) {
        return ((Set)this.fluids.get()).contains(fluid);
    }

    public FluidKey keyForOrEmpty(Fluid fluid) {
        return this.canContain(fluid) ? this.keyFor(fluid) : this.keyFor(Fluids.f_76191_);
    }

    public FluidKey keyFor(Fluid fluid) {
        FluidKey key = this.keysByFluid.get(fluid);
        if (key != null) {
            return key;
        }
        key = this.keysById.get(Objects.requireNonNull(fluid.getRegistryName()).m_135815_());
        if (key == null) {
            throw new IllegalArgumentException("Tried to get the FluidKey for a fluid [" + fluid.getRegistryName() + "] which was not present in property " + this.m_61708_() + " / " + this.m_6908_());
        }
        this.keysByFluid.put(fluid, key);
        return key;
    }

    public Collection<FluidKey> m_6908_() {
        return this.keysByIndex;
    }

    public String getName(FluidKey value) {
        return value.name.m_135815_();
    }

    public Optional<FluidKey> m_6215_(String value) {
        return Optional.ofNullable(this.keysById.get(value));
    }

    public static class FluidKey
    implements Comparable<FluidKey> {
        private final ResourceLocation name;
        private final RegistryObject<Fluid> fluid;

        private FluidKey(ResourceLocation name) {
            this.name = name;
            this.fluid = RegistryObject.create((ResourceLocation)name, (IForgeRegistry)ForgeRegistries.FLUIDS);
        }

        public Fluid getFluid() {
            return (Fluid)this.fluid.get();
        }

        public boolean is(FluidKey other) {
            return this.name.equals((Object)other.name);
        }

        @Override
        public int compareTo(FluidKey other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return "FluidKey[" + this.name + "]";
        }
    }
}

