/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.entities.AnimationState;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.PredicateMoveControl;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.TamableAi;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class TamableMammal
extends Mammal
implements OwnableEntity {
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.m_135353_(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Byte> DATA_PET_FLAGS = SynchedEntityData.m_135353_(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState sleepingAnimation = new AnimationState();
    public final AnimationState sittingAnimation = new AnimationState();
    private static final int SLEEPING_FLAG = 1;
    private static final int SITTING_FLAG = 4;
    private static final int INTERESTED_FLAG = 8;
    private static final int UNUSED_FLAG_2 = 16;
    private final Supplier<SoundEvent> sleeping;
    private Command command = Command.RELAX;
    private boolean needsCommandUpdate = false;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public TamableMammal(EntityType<? extends TFCAnimal> animal, Level level, TFCSounds.EntitySound sounds, MammalConfig config) {
        super(animal, level, sounds, config);
        this.sleeping = sounds.sleep().orElseThrow();
        this.f_21342_ = new PredicateMoveControl<TamableMammal>(this, e -> !e.isSitting() && !e.m_5803_());
    }

    protected Brain.Provider<? extends TamableMammal> m_5490_() {
        return Brain.m_21923_(TamableAi.MEMORY_TYPES, TamableAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return TamableAi.makeBrain((Brain<? extends TamableMammal>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<? extends TamableMammal> m_6274_() {
        return super.m_6274_();
    }

    @Override
    public void tickBrain() {
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        TamableAi.updateActivity(this, this.f_19797_ % 20 == 0);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        super.createGenes(tag, male);
        if (this.m_142504_() != null) {
            tag.m_128362_("owner", this.m_142504_());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof TamableMammal) {
            TamableMammal tamable = (TamableMammal)baby;
            if (tag.m_128403_("owner")) {
                tamable.setOwnerUUID(tag.m_128342_("owner"));
            }
        }
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            EntityHelpers.startOrStop(this.sittingAnimation, this.isSitting(), this.f_19797_);
            EntityHelpers.startOrStop(this.sleepingAnimation, this.m_5803_(), this.f_19797_);
            if (this.m_5803_() && this.m_21187_().nextInt(10) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)TFCParticles.SLEEP.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 0.01, 0.05, 0.01);
            }
        }
        super.m_8119_();
        if (this.needsCommandUpdate && this.command.activity != null) {
            this.m_6274_().m_21889_(this.command.activity.get());
            this.needsCommandUpdate = false;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER, Optional.empty());
        this.f_19804_.m_135372_(DATA_PET_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.WHITE.m_41060_());
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)color.m_41060_());
    }

    public boolean willListenTo(Command command, boolean isClientSide) {
        return command != Command.SIT || this.m_21223_() >= 5.0f;
    }

    public void receiveCommand(ServerPlayer player, Command command) {
        if (this.isOwnedBy((Entity)player)) {
            switch (command) {
                case RELAX: {
                    this.setSitting(false);
                    this.setSleeping(false);
                    break;
                }
                case SIT: {
                    this.setSitting(true);
                    this.setSleeping(false);
                    this.m_6274_().m_21879_((MemoryModuleType)TFCBrain.SIT_TIME.get(), (Object)Calendars.SERVER.getTicks());
                    this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                    this.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                    break;
                }
                case HOME: {
                    this.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)this.f_19853_.m_46472_(), (BlockPos)player.m_142538_()));
                    command = Command.RELAX;
                    break;
                }
                case FOLLOW: 
                case HUNT: {
                    this.setSitting(false);
                    this.setSleeping(false);
                    this.m_6274_().m_21936_((MemoryModuleType)TFCBrain.SIT_TIME.get());
                }
            }
            this.command = command;
            Activity commandedActivity = Command.getActivity(command);
            if (commandedActivity != null) {
                this.m_6274_().m_21889_(commandedActivity);
            }
        } else {
            player.m_5661_((Component)Helpers.translatable("tfc.pet.not_owner"), true);
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void refreshCommandOnNextTick() {
        this.needsCommandUpdate = true;
    }

    public boolean m_5803_() {
        return ((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS) & 1) != 0;
    }

    public void setSleeping(boolean sleep) {
        this.f_19804_.m_135381_(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS), 1, sleep));
    }

    public boolean isSitting() {
        return ((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS) & 4) != 0;
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS), 4, sitting));
    }

    public boolean isInterested() {
        return ((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS) & 8) != 0;
    }

    public void setInterested(boolean interested) {
        this.f_19804_.m_135381_(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS), 8, interested));
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        return (byte)(value ? oldBit | offset : oldBit & ~offset);
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID id) {
        this.f_19804_.m_135381_(DATA_OWNER, Optional.ofNullable(id));
    }

    @Nullable
    public Entity m_142480_() {
        try {
            UUID uuid = this.m_142504_();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        DyeItem dye;
        DyeColor color;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof DyeItem && (color = (dye = (DyeItem)item).m_41089_()) != this.getCollarColor()) {
            this.setCollarColor(color);
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (held.m_41619_() && player.m_6144_() && this.m_142480_() != null && this.isOwnedBy((Entity)player) && !this.m_6060_()) {
            if (this.f_19853_.f_46443_) {
                ClientHelpers.openPetScreen(this);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getFamiliarity() + 0.06f > 0.15f && this.m_142504_() == null && this.m_6898_(held) && this.isHungry()) {
            this.tame(player);
        }
        return super.m_6071_(player, hand);
    }

    public void spawnTamingParticles(ParticleOptions particle) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(particle, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 7, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, 1.0);
        }
    }

    public void tame(Player player) {
        this.setOwnerUUID(player.m_142081_());
        this.spawnTamingParticles((ParticleOptions)ParticleTypes.f_123750_);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10590_.m_68829_(serverPlayer, (Animal)this);
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isOwnedBy((Entity)target) && super.m_6779_(target);
    }

    public boolean isOwnedBy(@Nullable Entity entity) {
        return entity != null && entity.equals((Object)this.m_142480_());
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_142504_() != null) {
            tag.m_128362_("Owner", this.m_142504_());
        }
        tag.m_128405_("command", this.command.ordinal());
        tag.m_128344_("petFlags", ((Byte)this.f_19804_.m_135370_(DATA_PET_FLAGS)).byteValue());
        tag.m_128405_("CollarColor", this.getCollarColor().m_41060_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
        }
        this.command = Command.valueOf(tag.m_128451_("command"));
        this.f_19804_.m_135381_(DATA_PET_FLAGS, (Object)tag.m_128445_("petFlags"));
        this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        this.refreshCommandOnNextTick();
    }

    public void m_6667_(DamageSource source) {
        Entity entity;
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(source);
        if (this.f_20890_ && (entity = this.m_142480_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_)) {
                serverPlayer.m_6352_(deathMessage, Util.f_137441_);
            }
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        return this.m_5803_() ? this.sleeping.get() : super.m_7515_();
    }

    public static enum Command {
        RELAX((Supplier<Activity>)TFCBrain.IDLE_AT_HOME),
        HOME(null),
        SIT((Supplier<Activity>)TFCBrain.SIT),
        FOLLOW((Supplier<Activity>)TFCBrain.FOLLOW),
        HUNT((Supplier<Activity>)TFCBrain.HUNT);

        public static final Command[] VALUES;
        @Nullable
        private final Supplier<Activity> activity;

        public static Command valueOf(int id) {
            return VALUES[id];
        }

        @Nullable
        public static Activity getActivity(Command command) {
            return command.activity == null ? null : command.activity.get();
        }

        private Command(Supplier<Activity> activity) {
            this.activity = activity;
        }

        static {
            VALUES = Command.values();
        }
    }
}

