/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TFCChestedHorse
extends AbstractChestedHorse
implements HorseProperties {
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> BIRTHDAY = SynchedEntityData.m_135353_(TFCChestedHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Float> FAMILIARITY = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FERTILIZED = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> OLD_DAY = SynchedEntityData.m_135353_(TFCChestedHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Integer> GENETIC_SIZE = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final CommonAnimalData ANIMAL_DATA = new CommonAnimalData(GENDER, BIRTHDAY, FAMILIARITY, USES, FERTILIZED, OLD_DAY, GENETIC_SIZE);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.m_135353_(TFCChestedHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<ItemStack> CHEST_ITEM = SynchedEntityData.m_135353_(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private boolean overburdened = false;
    private long lastFed;
    private long lastFDecay;
    private long matingTime;
    @Nullable
    private CompoundTag genes;
    private TFCAnimalProperties.Age lastAge = TFCAnimalProperties.Age.CHILD;
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final Supplier<? extends SoundEvent> eat;
    private final Supplier<? extends SoundEvent> angry;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;

    public static boolean vanillaParentingCheck(AbstractHorse horse) {
        return !horse.m_20160_() && !horse.m_20159_() && horse.m_30614_() && !horse.m_6162_();
    }

    public TFCChestedHorse(EntityType<? extends TFCChestedHorse> type, Level level, TFCSounds.EntitySound sounds, Supplier<? extends SoundEvent> eatSound, Supplier<? extends SoundEvent> angrySound, MammalConfig config) {
        super(type, level);
        this.matingTime = Calendars.get((LevelReader)level).getTicks();
        this.lastFDecay = Calendars.get((LevelReader)level).getTotalDays();
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.eat = eatSound;
        this.angry = angrySound;
        this.config = config.inner();
        this.mammalConfig = config;
    }

    public double m_6048_() {
        return super.m_6048_() * (double)this.getAgeScale();
    }

    public ItemStack getChestItem() {
        return (ItemStack)this.f_19804_.m_135370_(CHEST_ITEM);
    }

    public void setChestItem(ItemStack stack) {
        this.f_19804_.m_135381_(CHEST_ITEM, (Object)stack);
    }

    public boolean m_30502_() {
        return !this.getChestItem().m_41619_() && Helpers.isItem(this.getChestItem(), (TagKey<Item>)Tags.Items.CHESTS_WOODEN);
    }

    public void m_5757_(Container container) {
        super.m_5757_(container);
        this.overburdened = Helpers.countOverburdened(container) == 1;
    }

    protected void m_8099_() {
        super.m_8099_();
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 3);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)this.getFoodTag()), false));
        this.f_21345_.m_25352_(5, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
    }

    protected void m_5907_() {
        if (!this.getChestItem().m_41619_()) {
            if (!this.f_19853_.f_46443_) {
                this.m_19983_(this.getChestItem());
            }
            this.setChestItem(ItemStack.f_41583_);
        }
        super.m_5907_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7848_(Animal otherAnimal) {
        if (!(otherAnimal instanceof TFCAnimalProperties)) return false;
        TFCAnimalProperties other = (TFCAnimalProperties)otherAnimal;
        if (this.getGender() == other.getGender()) return false;
        if (!this.isReadyToMate()) return false;
        if (!other.isReadyToMate()) return false;
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result = HorseProperties.super.mobInteract(player, hand);
        if (result == InteractionResult.PASS) {
            ItemStack stack = player.m_21120_(hand);
            if (!this.m_6162_()) {
                if (this.m_30614_() && player.m_36341_()) {
                    if (!this.m_30502_() && !this.getChestItem().m_41619_()) {
                        if (stack.m_41619_()) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getChestItem().m_41777_());
                            this.setChestItem(ItemStack.f_41583_);
                            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                        }
                        IFluidHandlerItem destFluidItemHandler = Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
                        IFluidHandlerItem sourceFluidItemHandler = Helpers.getCapability((ICapabilityProvider)this.getChestItem(), Capabilities.FLUID_ITEM);
                        if (destFluidItemHandler != null && sourceFluidItemHandler != null && FluidHelpers.transferBetweenItemAndOther(this.getChestItem(), destFluidItemHandler, (IFluidHandler)sourceFluidItemHandler, (IFluidHandler)destFluidItemHandler, FluidHelpers.Transfer.FILL, this.f_19853_, this.m_142538_(), new FluidHelpers.AfterTransferWithPlayer(player, hand))) {
                            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                        }
                    }
                    this.m_30620_(player);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (this.m_20160_()) {
                    return InteractionResult.PASS;
                }
            }
            if (!stack.m_41619_()) {
                if (!this.m_30614_()) {
                    this.m_7564_();
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (this.getChestItem().m_41619_() && Helpers.isItem(stack, TFCTags.Items.CARRIED_BY_HORSE)) {
                    this.setChestItem(stack.m_41777_());
                    this.m_7609_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    this.m_30625_();
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (!this.m_6162_() && !this.m_6254_() && stack.m_150930_(Items.f_42450_)) {
                    this.m_30620_(player);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
            if (this.m_6162_()) {
                return InteractionResult.PASS;
            }
            if (this.m_30614_() && this.m_30615_() == null) {
                this.m_30637_(player);
            }
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return result;
    }

    public boolean m_30614_() {
        return this.getFamiliarity() > 0.15f;
    }

    public SlotAccess m_141942_(int slot) {
        return slot == 499 ? new SlotAccess(){

            public ItemStack m_142196_() {
                return TFCChestedHorse.this.getChestItem();
            }

            public boolean m_142104_(ItemStack stack) {
                TFCChestedHorse horse = TFCChestedHorse.this;
                if (stack.m_41619_()) {
                    if (horse.m_30502_()) {
                        horse.setChestItem(ItemStack.f_41583_);
                        horse.m_30625_();
                    }
                    return true;
                }
                if (Helpers.isItem(stack, TFCTags.Items.CARRIED_BY_HORSE)) {
                    if (!horse.m_30502_()) {
                        horse.setChestItem(stack);
                        horse.m_30625_();
                    }
                    return true;
                }
                return false;
            }
        } : super.m_141942_(slot);
    }

    protected SoundEvent m_7872_() {
        super.m_7872_();
        return this.eat.get();
    }

    protected SoundEvent m_7871_() {
        super.m_7871_();
        return this.angry.get();
    }

    protected float m_6041_() {
        return Helpers.isBlock(this.f_19853_.m_8055_(this.m_142538_()), TFCTags.Blocks.PLANTS) ? 1.0f : super.m_6041_();
    }

    @Override
    public TFCAnimalProperties.Age getLastAge() {
        return this.lastAge;
    }

    @Override
    public void setLastAge(TFCAnimalProperties.Age lastAge) {
        this.lastAge = lastAge;
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player) && !this.overburdened;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, tag);
        if (reason != MobSpawnType.BREEDING) {
            this.initCommonAnimalData();
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.f_19804_.m_135370_(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.f_19804_.m_135381_(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerCommonData();
        this.f_19804_.m_135372_(PREGNANT_TIME, (Object)-1L);
        this.f_19804_.m_135372_(CHEST_ITEM, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("chestItem", (Tag)this.getChestItem().m_41739_(new CompoundTag()));
        super.m_7380_(nbt);
        this.saveCommonAnimalData(nbt);
        nbt.m_128379_("overburdened", this.overburdened);
    }

    public void m_7378_(CompoundTag nbt) {
        this.setChestItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chestItem")));
        super.m_7378_(nbt);
        this.readCommonAnimalData(nbt);
        this.overburdened = nbt.m_128471_("overburdened");
    }

    public boolean m_6162_() {
        return this.getAgeType() == TFCAnimalProperties.Age.CHILD;
    }

    public void m_146762_(int age) {
        super.m_146762_(0);
    }

    public int m_146764_() {
        return this.m_6162_() ? -24000 : 0;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        return HorseProperties.super.getBreedOffspring(level, other);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (BIRTHDAY.equals(data)) {
            this.m_6210_();
        }
    }

    @Override
    public long getLastFamiliarityDecay() {
        return this.lastFDecay;
    }

    @Override
    public void setLastFamiliarityDecay(long days) {
        this.lastFDecay = days;
    }

    @Override
    public void setLastFed(long fed) {
        this.lastFed = fed;
    }

    @Override
    public long getLastFed() {
        return this.lastFed;
    }

    @Override
    public void setMated(long ticks) {
        this.matingTime = ticks;
    }

    @Override
    public long getMated() {
        return this.matingTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_46467_() % 20L == 0L) {
            this.tickAnimalData();
            if (this.overburdened) {
                this.m_7292_(Helpers.getOverburdened(true));
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return HorseProperties.super.isFood(stack);
    }

    public Component m_5677_() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return this.ambient.get();
    }

    protected SoundEvent m_7975_(DamageSource src) {
        super.m_7975_(src);
        return this.hurt.get();
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return this.death.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        super.m_7355_(pos, block);
        this.m_5496_(this.step.get(), 0.15f, 1.0f);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_204336_(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.m_46863_(pos) - 0.5f;
    }

    public PathNavigation m_6037_(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean m_5830_() {
        return !this.f_19853_.f_46443_ && super.m_5830_();
    }

    protected void m_6138_() {
        if (!this.f_19853_.f_46443_) {
            super.m_6138_();
        }
    }
}

