/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import java.util.EnumSet;
import net.dries007.tfc.common.entities.ThrownJavelin;
import net.dries007.tfc.common.items.JavelinItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;

public class JavelinAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public JavelinAttackGoal(T mob, double speed, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speed;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.isHoldingJavelin();
    }

    protected boolean isHoldingJavelin() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof JavelinItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingJavelin();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean hasSeen;
            double distSquared = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean seeing = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (seeing != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime += seeing ? 1 : -1;
            if (!(distSquared > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_21187_().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_21187_().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distSquared > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distSquared < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.mob.m_6117_()) {
                if (!seeing && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (seeing && this.mob.m_21252_() >= 20) {
                    this.mob.m_5810_();
                    this.performRangedAttack(livingentity);
                    this.attackTime = ((Mob)this.mob).f_19853_.m_46791_() == Difficulty.HARD ? 20 : 40;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(this.getHand());
            }
        }
    }

    public void performRangedAttack(LivingEntity target) {
        ItemStack itemstack = this.getWeaponInHand();
        ThrownJavelin javelin = new ThrownJavelin(((Mob)this.mob).f_19853_, (LivingEntity)this.mob, itemstack);
        double dx = target.m_20185_() - this.mob.m_20185_();
        double dy = target.m_20227_(0.3333333333333333) - javelin.m_20186_();
        double dz = target.m_20189_() - this.mob.m_20189_();
        double dist = Math.sqrt(dx * dx + dz * dz);
        javelin.m_6686_(dx, dy + dist * (double)0.2f, dz, 1.6f, 14 - ((Mob)this.mob).f_19853_.m_46791_().m_19028_() * 4);
        this.mob.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.mob.m_21187_().nextFloat() * 0.4f + 0.8f));
        ((Mob)this.mob).f_19853_.m_7967_((Entity)javelin);
    }

    public ItemStack getWeaponInHand() {
        return this.mob.m_21120_(this.getHand());
    }

    public InteractionHand getHand() {
        return ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof JavelinItem);
    }
}

