/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class WildAnimal
extends AgeableMob
implements GenderedRenderAnimal {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.m_135353_(WildAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_BABY = SynchedEntityData.m_135353_(WildAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final Supplier<SoundEvent> ambient;
    protected final Supplier<SoundEvent> death;
    protected final Supplier<SoundEvent> hurt;
    protected final Supplier<SoundEvent> step;

    public WildAnimal(EntityType<? extends AgeableMob> type, Level level, TFCSounds.EntitySound sounds) {
        super(type, level);
        this.ambient = sounds.ambient();
        this.death = sounds.death();
        this.hurt = sounds.hurt();
        this.step = sounds.step();
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_46467_() % 4000L == 0L && this.f_19796_.nextInt(2000) == 0) {
            this.m_6863_(false);
        }
    }

    @Override
    public boolean displayMaleCharacteristics() {
        return this.isMale() && !this.m_6162_();
    }

    @Override
    public boolean displayFemaleCharacteristics() {
        return !this.isMale();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_MALE, (Object)true);
        this.f_19804_.m_135372_(DATA_IS_BABY, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_IS_BABY.equals(key)) {
            this.m_6210_();
        }
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_MALE);
    }

    public void setIsMale(boolean male) {
        this.f_19804_.m_135381_(DATA_IS_MALE, (Object)male);
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_BABY);
    }

    public void m_6863_(boolean baby) {
        this.f_19804_.m_135381_(DATA_IS_BABY, (Object)baby);
    }

    public void m_146762_(int age) {
        super.m_146762_(0);
    }

    public int m_146764_() {
        return this.m_6162_() ? -24000 : 0;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, data, tag);
        this.setIsMale(level.m_5822_().nextBoolean());
        this.m_6863_(this.f_19796_.nextFloat() < 0.1f);
        return super.m_6518_(level, difficulty, type, spawnData, tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("male", this.isMale());
        tag.m_128379_("baby", this.m_6162_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setIsMale(tag.m_128471_("male"));
        this.m_6863_(tag.m_128471_("baby"));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)this.m_6095_().m_20615_((Level)level);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.step.get(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return this.hurt.get();
    }

    protected SoundEvent m_5592_() {
        return this.death.get();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return Helpers.isEntity((Entity)this, TFCTags.Entities.LEASHABLE_WILD_ANIMALS);
    }

    protected PathNavigation m_6037_(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_204336_(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.m_46863_(pos) - 0.5f;
    }
}

