/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class TFCFishingHook
extends FishingHook
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<ItemStack> BAIT = SynchedEntityData.m_135353_(TFCFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public int pullExhaustion = 0;
    private float strength = 0.04f;
    private long lastPulled = 0L;

    public TFCFishingHook(EntityType<? extends TFCFishingHook> type, Level level) {
        super(type, level);
    }

    public TFCFishingHook(Player player, Level level, float strength, ItemStack bait) {
        this((EntityType<? extends TFCFishingHook>)((EntityType)TFCEntities.FISHING_BOBBER.get()), level);
        this.m_5602_((Entity)player);
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.m_20185_() - (double)f3 * 0.3;
        double d1 = player.m_20188_();
        double d2 = player.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        vec3 = vec3.m_82542_(0.6 / d3 + 0.5 + this.f_19796_.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.nextGaussian() * 0.0045);
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.strength = strength;
        this.setBait(bait);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BAIT, (Object)ItemStack.f_41583_);
    }

    public void setBait(ItemStack item) {
        this.f_19804_.m_135381_(BAIT, (Object)item);
    }

    public ItemStack getBait() {
        return (ItemStack)this.f_19804_.m_135370_(BAIT);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_37094_ != null && !this.f_37094_.m_146910_()) {
            this.f_37095_ = FishingHook.FishHookState.HOOKED_IN_ENTITY;
            this.m_6034_(this.f_37094_.m_20185_(), this.f_37094_.m_20227_(0.8), this.f_37094_.m_20189_());
        }
        if (this.pullExhaustion > 0) {
            --this.pullExhaustion;
        }
    }

    public boolean m_37136_(Player player) {
        boolean main = player.m_21205_().m_41720_() instanceof TFCFishingRodItem;
        boolean off = player.m_21206_().m_41720_() instanceof TFCFishingRodItem;
        if (!player.m_146910_() && player.m_6084_() && (main || off) && !(this.m_20280_((Entity)player) > 1024.0)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    public void m_37145_(BlockPos pos) {
    }

    public int m_37156_(ItemStack stack) {
        Player player = this.m_37168_();
        long diff = this.f_19853_.m_46467_() - this.lastPulled;
        if (diff < 25L) {
            this.pullExhaustion = (int)((long)this.pullExhaustion + (25L - diff) * 2L);
            if (this.pullExhaustion > 100) {
                if (player != null && this.f_19853_.f_46443_) {
                    player.m_5661_((Component)Helpers.translatable("tfc.fishing.pulled_too_hard"), true);
                }
                this.eatBait();
                this.m_5496_(SoundEvents.f_12018_, 1.0f, 0.5f + this.f_19796_.nextFloat());
                this.m_146870_();
                return 1;
            }
            this.m_5496_(SoundEvents.f_11941_, 1.0f, 0.5f + this.f_19796_.nextFloat());
        }
        this.lastPulled = this.f_19853_.m_46467_();
        if (!this.f_19853_.f_46443_ && player != null && !this.m_37136_(player)) {
            if (this.f_37094_ != null) {
                this.m_150155_(this.f_37094_);
                if (this.f_37094_ instanceof AbstractFish) {
                    player.m_36222_(Stats.f_12939_, 1);
                }
                TFCAdvancements.HOOKED_ENTITY.trigger((ServerPlayer)player, this.f_37094_);
                this.f_19853_.m_7605_((Entity)this, (byte)31);
            }
            if (this.f_37094_ == null || this.f_37094_.m_146910_()) {
                this.m_146870_();
            }
            return this.f_19861_ ? 2 : 1;
        }
        return 0;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.m_37282_();
        buffer.m_130130_(owner == null ? this.m_142049_() : owner.m_142049_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int id = additionalData.m_130242_();
        Entity entity = this.f_19853_.m_6815_(id);
        if (entity != null) {
            this.m_5602_(entity);
        }
        if (this.m_37168_() == null) {
            TerraFirmaCraft.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.f_19853_.m_6815_(id), (Object)id);
            this.m_6074_();
        }
    }

    protected void m_150155_(Entity entity) {
        Entity owner = this.m_37282_();
        if (owner != null) {
            double dx = owner.m_20185_() - this.m_20185_();
            double dy = owner.m_20186_() - this.m_20186_();
            double dz = owner.m_20189_() - this.m_20189_();
            if (dy > 0.0 && dx < 5.0 && dz < 5.0) {
                dy = 4.0;
            }
            entity.m_20256_(new Vec3(dx, dy, dz).m_82541_().m_82490_((double)this.strength));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128356_("lastPulled", this.lastPulled);
        tag.m_128405_("exhaustion", this.pullExhaustion);
        tag.m_128350_("strength", this.strength);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.lastPulled = tag.m_128454_("lastPulled");
        this.pullExhaustion = tag.m_128451_("exhaustion");
        this.strength = tag.m_128457_("strength");
    }

    public void eatBait() {
        Player owner = this.m_37168_();
        if (owner != null) {
            ItemStack main = owner.m_21205_();
            ItemStack off = owner.m_21206_();
            ItemStack use = ItemStack.f_41583_;
            if (main.m_41720_() instanceof TFCFishingRodItem) {
                use = main;
            } else if (off.m_41720_() instanceof TFCFishingRodItem) {
                use = off;
            }
            if (!use.m_41619_()) {
                use.m_41749_("bait");
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

