/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.entities.AnimationState;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public final class EntityHelpers {
    public static final EntityDataSerializer<Long> LONG_SERIALIZER = new EntityDataSerializer<Long>(){

        public void write(FriendlyByteBuf buf, Long value) {
            buf.m_130103_(value.longValue());
        }

        public Long read(FriendlyByteBuf buf) {
            return buf.m_130258_();
        }

        public Long copy(Long value) {
            return value;
        }
    };

    public static void replaceAvoidEntityGoal(PathfinderMob mob, GoalSelector selector, int priority) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26015_() instanceof AvoidEntityGoal);
        selector.m_25352_(priority, new TFCAvoidEntityGoal<Player>(mob, Player.class, 8.0f, 5.0, 5.4));
    }

    public static void removeGoalOfPriority(GoalSelector selector, int priority) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26012_() == priority);
    }

    public static void removeGoalOfClass(GoalSelector selector, Class<?> clazz) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26015_().getClass() == clazz);
    }

    public static ChunkData getChunkDataForSpawning(ServerLevelAccessor level, BlockPos pos) {
        ChunkData chunkData;
        if (level instanceof WorldGenRegion) {
            WorldGenRegion worldGenLevel = (WorldGenRegion)level;
            chunkData = ChunkDataProvider.get((WorldGenLevel)worldGenLevel).get(new ChunkPos(pos));
        } else {
            chunkData = ChunkData.get((LevelReader)level, pos);
        }
        return chunkData;
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack held = player.m_21120_(hand);
        ItemStack bucketItem = ((Bucketable)entity).m_142563_();
        Item item = bucketItem.m_41720_();
        if (item instanceof MobBucketItem) {
            MobBucketItem mobBucket = (MobBucketItem)item;
            item = held.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem heldBucket = (BucketItem)item;
                if (mobBucket.getFluid().m_6212_(heldBucket.getFluid()) && entity.m_6084_()) {
                    entity.m_5496_(((Bucketable)entity).m_142623_(), 1.0f, 1.0f);
                    ((Bucketable)entity).m_142146_(bucketItem);
                    ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)held, (Player)player, (ItemStack)bucketItem, (boolean)false);
                    player.m_21008_(hand, itemstack2);
                    Level level = entity.f_19853_;
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketItem);
                    }
                    entity.m_146870_();
                    return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
                }
            }
        }
        return Optional.empty();
    }

    @Deprecated
    public static long getRandomGrowth(Random random, int daysToAdult) {
        if (random.nextFloat() < 0.05f) {
            return Calendars.get().getTotalDays() + (long)random.nextInt(10);
        }
        int lifeTimeDays = daysToAdult + random.nextInt(daysToAdult);
        return Calendars.get().getTotalDays() - (long)lifeTimeDays;
    }

    public static long getRandomGrowth(Entity entity, Random random, int daysToAdult) {
        if (random.nextFloat() < 0.05f) {
            return Calendars.get((LevelReader)entity.f_19853_).getTotalDays() + (long)random.nextInt(10);
        }
        int lifeTimeDays = daysToAdult + random.nextInt(daysToAdult);
        return Calendars.get((LevelReader)entity.f_19853_).getTotalDays() - (long)lifeTimeDays;
    }

    public static void setNullableAttribute(LivingEntity entity, Attribute attribute, double baseValue) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(baseValue);
        }
    }

    public static int getIntOrDefault(CompoundTag nbt, String key, int defaultInt) {
        return nbt.m_128425_(key, 3) ? nbt.m_128451_(key) : defaultInt;
    }

    public static float getFloatOrDefault(CompoundTag nbt, String key, float defaultFloat) {
        return nbt.m_128425_(key, 5) ? nbt.m_128457_(key) : defaultFloat;
    }

    public static long getLongOrDefault(CompoundTag nbt, String key, long defaultLong) {
        return nbt.m_128425_(key, 4) ? nbt.m_128454_(key) : defaultLong;
    }

    public static <T extends Animal> void findFemaleMate(T maleAnimal) {
        List list = maleAnimal.f_19853_.m_45976_(Animal.class, maleAnimal.m_142469_().m_82400_(8.0));
        for (Animal femaleAnimal : list) {
            TFCAnimalProperties femaleData;
            if (!(femaleAnimal instanceof TFCAnimalProperties) || (femaleData = (TFCAnimalProperties)femaleAnimal).getGender() != TFCAnimalProperties.Gender.FEMALE || femaleAnimal.m_27593_() || !femaleData.isReadyToMate() || !femaleData.checkExtraBreedConditions((TFCAnimalProperties)maleAnimal)) continue;
            femaleAnimal.m_27595_(null);
            maleAnimal.m_27595_(null);
            break;
        }
    }

    public static boolean isMovingOnLand(Entity entity) {
        return entity.m_20096_() && entity.m_20184_().m_82556_() > 1.0E-6 && !entity.m_20072_();
    }

    public static boolean isMovingInWater(Entity entity) {
        return entity.m_20072_();
    }

    public static boolean startOrStop(AnimationState state, boolean go, int tickCount) {
        if (go) {
            state.startIfStopped(tickCount);
        } else {
            state.stop();
        }
        return go;
    }

    public static boolean pluck(Player player, InteractionHand hand, LivingEntity entity) {
        if (player.m_21120_(hand).m_41619_() && player.m_6144_() && !entity.f_19853_.f_46443_ && entity.m_21223_() / entity.m_21233_() > 0.15001f) {
            ItemStack feather = new ItemStack((ItemLike)Items.f_42402_, Mth.m_14072_((Random)entity.m_21187_(), (int)1, (int)3));
            if (entity instanceof TFCAnimalProperties) {
                AnimalProductEvent event;
                TFCAnimalProperties properties = (TFCAnimalProperties)entity;
                if (properties.getAgeType() == TFCAnimalProperties.Age.ADULT && !MinecraftForge.EVENT_BUS.post((Event)(event = new AnimalProductEvent(entity.f_19853_, entity.m_142538_(), player, properties, feather, ItemStack.f_41583_, 1)))) {
                    TFCDamageSources.pluck((Entity)entity, entity.m_21233_() * 0.15f);
                    properties.addUses(event.getUses());
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)event.getProduct());
                }
            } else {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)feather);
                TFCDamageSources.pluck((Entity)entity, entity.m_21233_() * 0.15f);
            }
            return true;
        }
        return false;
    }

    public static double createOffspringAttribute(double value1, double value2, double min, double max, Random random) {
        double gaussian;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = Mth.m_14008_((double)value1, (double)min, (double)max);
        value2 = Mth.m_14008_((double)value2, (double)min, (double)max);
        double wiggleRoom = 0.15 * (max - min);
        double average = (value1 + value2) / 2.0;
        double randomRange = Math.abs(value1 - value2) + wiggleRoom * 2.0;
        double newValue = average + randomRange * (gaussian = (random.nextDouble() + random.nextDouble() + random.nextDouble()) / 3.0 - 0.5);
        if (newValue > max) {
            double diff = newValue - max;
            return max - diff;
        }
        if (newValue < min) {
            double diff = min - newValue;
            return min + diff;
        }
        return newValue;
    }
}

