/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.container.AnvilPlanContainer;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.CharcoalForgeContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.container.LargeVesselContainer;
import net.dries007.tfc.common.container.LeatherKnappingContainer;
import net.dries007.tfc.common.container.LogPileContainer;
import net.dries007.tfc.common.container.MoldLikeAlloyContainer;
import net.dries007.tfc.common.container.NestBoxContainer;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.container.PowderkegContainer;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.SaladContainer;
import net.dries007.tfc.common.container.ScribingTableContainer;
import net.dries007.tfc.common.container.SmallVesselInventoryContainer;
import net.dries007.tfc.common.container.TFCWorkbenchContainer;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class TFCContainerTypes {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"tfc");
    public static final RegistryObject<MenuType<Container>> CALENDAR = TFCContainerTypes.register("calendar", (windowId, inv, data) -> Container.create((MenuType)CALENDAR.get(), windowId, inv));
    public static final RegistryObject<MenuType<Container>> NUTRITION = TFCContainerTypes.register("nutrition", (windowId, inv, data) -> Container.create((MenuType)NUTRITION.get(), windowId, inv));
    public static final RegistryObject<MenuType<Container>> CLIMATE = TFCContainerTypes.register("climate", (windowId, inv, data) -> Container.create((MenuType)CLIMATE.get(), windowId, inv));
    public static final RegistryObject<MenuType<SaladContainer>> SALAD = TFCContainerTypes.register("salad", (windowId, inv, data) -> SaladContainer.create(windowId, inv));
    public static final RegistryObject<MenuType<TFCWorkbenchContainer>> WORKBENCH = TFCContainerTypes.register("workbench", (windowId, inv, data) -> new TFCWorkbenchContainer(windowId, inv));
    public static final RegistryObject<MenuType<ScribingTableContainer>> SCRIBING_TABLE = TFCContainerTypes.register("scribing_table", (windowId, inv, data) -> new ScribingTableContainer(inv, windowId));
    public static final RegistryObject<MenuType<FirepitContainer>> FIREPIT = TFCContainerTypes.registerBlock("firepit", TFCBlockEntities.FIREPIT, FirepitContainer::create);
    public static final RegistryObject<MenuType<GrillContainer>> GRILL = TFCContainerTypes.registerBlock("grill", TFCBlockEntities.GRILL, GrillContainer::create);
    public static final RegistryObject<MenuType<PotContainer>> POT = TFCContainerTypes.registerBlock("pot", TFCBlockEntities.POT, PotContainer::create);
    public static final RegistryObject<MenuType<CharcoalForgeContainer>> CHARCOAL_FORGE = TFCContainerTypes.registerBlock("charcoal_forge", TFCBlockEntities.CHARCOAL_FORGE, CharcoalForgeContainer::create);
    public static final RegistryObject<MenuType<LogPileContainer>> LOG_PILE = TFCContainerTypes.registerBlock("log_pile", TFCBlockEntities.LOG_PILE, LogPileContainer::create);
    public static final RegistryObject<MenuType<CrucibleContainer>> CRUCIBLE = TFCContainerTypes.registerBlock("crucible", TFCBlockEntities.CRUCIBLE, CrucibleContainer::create);
    public static final RegistryObject<MenuType<BarrelContainer>> BARREL = TFCContainerTypes.registerBlock("barrel", TFCBlockEntities.BARREL, BarrelContainer::create);
    public static final RegistryObject<MenuType<PowderkegContainer>> POWDERKEG = TFCContainerTypes.registerBlock("powderkeg", TFCBlockEntities.POWDERKEG, PowderkegContainer::create);
    public static final RegistryObject<MenuType<NestBoxContainer>> NEST_BOX = TFCContainerTypes.registerBlock("nest_box", TFCBlockEntities.NEST_BOX, NestBoxContainer::create);
    public static final RegistryObject<MenuType<LargeVesselContainer>> LARGE_VESSEL = TFCContainerTypes.registerBlock("large_vessel", TFCBlockEntities.LARGE_VESSEL, LargeVesselContainer::create);
    public static final RegistryObject<MenuType<AnvilContainer>> ANVIL = TFCContainerTypes.registerBlock("anvil", TFCBlockEntities.ANVIL, AnvilContainer::create);
    public static final RegistryObject<MenuType<AnvilPlanContainer>> ANVIL_PLAN = TFCContainerTypes.registerBlock("anvil_plan", TFCBlockEntities.ANVIL, AnvilPlanContainer::create);
    public static final RegistryObject<MenuType<BlastFurnaceContainer>> BLAST_FURNACE = TFCContainerTypes.registerBlock("blast_furnace", TFCBlockEntities.BLAST_FURNACE, BlastFurnaceContainer::create);
    public static final RegistryObject<MenuType<RestrictedChestContainer>> CHEST_9x2 = TFCContainerTypes.register("chest_9x2", RestrictedChestContainer::twoRows);
    public static final RegistryObject<MenuType<RestrictedChestContainer>> CHEST_9x4 = TFCContainerTypes.register("chest_9x4", RestrictedChestContainer::fourRows);
    public static final RegistryObject<MenuType<KnappingContainer>> CLAY_KNAPPING = TFCContainerTypes.registerItem("clay_knapping", KnappingContainer::createClay);
    public static final RegistryObject<MenuType<KnappingContainer>> FIRE_CLAY_KNAPPING = TFCContainerTypes.registerItem("fire_clay_knapping", KnappingContainer::createFireClay);
    public static final RegistryObject<MenuType<LeatherKnappingContainer>> LEATHER_KNAPPING = TFCContainerTypes.registerItem("leather_knapping", KnappingContainer::createLeather);
    public static final RegistryObject<MenuType<KnappingContainer>> ROCK_KNAPPING = TFCContainerTypes.registerItem("rock_knapping", KnappingContainer::createRock);
    public static final RegistryObject<MenuType<SmallVesselInventoryContainer>> SMALL_VESSEL_INVENTORY = TFCContainerTypes.registerItem("small_vessel_inventory", SmallVesselInventoryContainer::create);
    public static final RegistryObject<MenuType<MoldLikeAlloyContainer>> MOLD_LIKE_ALLOY = TFCContainerTypes.registerItem("mold_like_alloy", MoldLikeAlloyContainer::create);

    private static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> RegistryObject<MenuType<C>> registerBlock(String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return RegistrationHelpers.registerBlockEntityContainer(CONTAINERS, name, type, factory);
    }

    private static <C extends ItemStackContainer> RegistryObject<MenuType<C>> registerItem(String name, ItemStackContainer.Factory<C> factory) {
        return RegistrationHelpers.registerItemStackContainer(CONTAINERS, name, factory);
    }

    private static <C extends AbstractContainerMenu> RegistryObject<MenuType<C>> register(String name, IContainerFactory<C> factory) {
        return RegistrationHelpers.registerContainer(CONTAINERS, name, factory);
    }
}

