/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class FirepitContainer
extends BlockEntityContainer<FirepitBlockEntity> {
    public static FirepitContainer create(FirepitBlockEntity tile, Inventory playerInv, int windowId) {
        return (FirepitContainer)((Object)new FirepitContainer(tile, windowId).init(playerInv, 20));
    }

    private FirepitContainer(FirepitBlockEntity tile, int windowId) {
        super((MenuType)TFCContainerTypes.FIREPIT.get(), windowId, tile);
        this.m_38884_(tile.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, 3, 5, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        ((FirepitBlockEntity)this.blockEntity).getCapability(Capabilities.ITEM).ifPresent(handler -> {
            for (int i = 0; i < 4; ++i) {
                this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, i, 8, 70 - 18 * i));
            }
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 4, 80, 29));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 5, 71, 57));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 6, 89, 57));
        });
    }
}

