/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BarrelContainer
extends BlockEntityContainer<BarrelBlockEntity>
implements ButtonHandlerContainer {
    public static BarrelContainer create(BarrelBlockEntity barrel, Inventory playerInv, int windowId) {
        return (BarrelContainer)new BarrelContainer(windowId, barrel).init(playerInv, 12);
    }

    private BarrelContainer(int windowId, BarrelBlockEntity barrel) {
        super((MenuType)TFCContainerTypes.BARREL.get(), windowId, barrel);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        Level level = ((BarrelBlockEntity)this.blockEntity).m_58904_();
        if (level != null) {
            BarrelBlock.toggleSeal(level, ((BarrelBlockEntity)this.blockEntity).m_58899_(), ((BarrelBlockEntity)this.blockEntity).m_58900_());
        }
    }

    @Override
    protected void addContainerSlots() {
        ((BarrelBlockEntity)this.blockEntity).getCapability(Capabilities.ITEM).ifPresent(inventory -> {
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)inventory, 0, 35, 20));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)inventory, 1, 35, 54));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)inventory, 2, 89, 37));
        });
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        if (((Boolean)((BarrelBlockEntity)this.blockEntity).m_58900_().m_61143_((Property)BarrelBlock.SEALED)).booleanValue()) {
            return true;
        }
        int containerSlot = stack.getCapability(Capabilities.FLUID_ITEM).isPresent() && stack.getCapability(HeatCapability.CAPABILITY).map(cap -> cap.getTemperature() == 0.0f).orElse(false) != false ? 0 : 2;
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, containerSlot, containerSlot + 1, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
        };
    }
}

