/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class CountBlockCommand {
    private static final String DONE = "tfc.commands.countblock.done";
    private static final DynamicCommandExceptionType ERROR_INVALID_BLOCK = new DynamicCommandExceptionType(block -> Helpers.translatable("tfc.commands.countblock.invalid_block", block));

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"count").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.m_82129_((String)"block", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122901_)).executes(context -> CountBlockCommand.countBlock((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), CountBlockCommand.getRegistryType((CommandContext<CommandSourceStack>)context, "block", Registry.f_122901_, ERROR_INVALID_BLOCK)))));
    }

    public static <T> ResourceOrTagLocationArgument.Result<T> getRegistryType(CommandContext<CommandSourceStack> context, String name, ResourceKey<Registry<T>> key, DynamicCommandExceptionType error) throws CommandSyntaxException {
        ResourceOrTagLocationArgument.Result result = (ResourceOrTagLocationArgument.Result)context.getArgument(name, ResourceOrTagLocationArgument.Result.class);
        return (ResourceOrTagLocationArgument.Result)result.m_207209_(key).orElseThrow(() -> error.create((Object)result));
    }

    private static int countBlock(CommandSourceStack source, int radius, ResourceOrTagLocationArgument.Result<Block> block) {
        ServerLevel level = source.m_81372_();
        BlockPos center = new BlockPos(source.m_81371_());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Predicate predicate = (Predicate)block.m_207418_().mapLeft(lr -> (Block)ForgeRegistries.BLOCKS.getValue(lr.m_135782_())).map(lr -> b -> b == lr, rr -> b -> Helpers.isBlock(b, (TagKey<Block>)rr));
        int found = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                    mutablePos.m_122190_((Vec3i)center).m_122184_(x, 0, z).m_142448_(y);
                    BlockState state = level.m_8055_((BlockPos)mutablePos);
                    if (!predicate.test(state.m_60734_())) continue;
                    ++found;
                }
            }
        }
        source.m_81354_((Component)Helpers.translatable(DONE, found, block.m_207276_()), true);
        return 1;
    }
}

