/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.size;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeDefinition;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.mixin.accessor.ItemAccessor;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public final class ItemSizeManager {
    public static final DataManager<ItemSizeDefinition> MANAGER = new DataManager<ItemSizeDefinition>(Helpers.identifier("item_sizes"), "item size", ItemSizeDefinition::new, ItemSizeDefinition::new, ItemSizeDefinition::encode, Packet::new);
    public static final IndirectHashCollection<Item, ItemSizeDefinition> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Item> MODIFIABLE_ITEMS = new ArrayList<Item>();

    public static void setupItemStackSizeOverrides() {
        MODIFIABLE_ITEMS.clear();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (item.m_41459_() <= 1 || stack.m_41741_() != item.m_41459_()) continue;
            MODIFIABLE_ITEMS.add(item);
        }
    }

    public static void applyItemStackSizeOverrides() {
        LOGGER.info("Editing item stack sizes: found {} editable of {} total.", (Object)MODIFIABLE_ITEMS.size(), (Object)ForgeRegistries.ITEMS.getValues().size());
        for (Item item : MODIFIABLE_ITEMS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            IItemSize size = ItemSizeManager.get(stack);
            ((ItemAccessor)item).accessor$setMaxStackSize(size.getDefaultStackSize(stack));
        }
    }

    public static void addTooltipInfo(ItemStack stack, List<Component> text) {
        IItemSize size = ItemSizeManager.get(stack);
        text.add((Component)Helpers.literal("\u2696 ").m_7220_((Component)Helpers.translateEnum(size.getWeight(stack))).m_130946_(" \u21f2 ").m_7220_((Component)Helpers.translateEnum(size.getSize(stack))).m_130940_(ChatFormatting.GRAY));
    }

    public static IItemSize get(ItemStack stack) {
        BlockItem block;
        Block block2;
        Item item = stack.m_41720_();
        if (item instanceof IItemSize) {
            IItemSize size = (IItemSize)item;
            return size;
        }
        if (item instanceof BlockItem && (block2 = (block = (BlockItem)item).m_40614_()) instanceof IItemSize) {
            IItemSize size = (IItemSize)block2;
            return size;
        }
        for (ItemSizeDefinition def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        if (item instanceof TieredItem) {
            return ItemSize.of(Size.LARGE, Weight.MEDIUM);
        }
        if (item instanceof ArmorItem || item instanceof HorseArmorItem) {
            return ItemSize.of(Size.LARGE, Weight.VERY_HEAVY);
        }
        if (item instanceof BlockItem) {
            return ItemSize.of(Size.SMALL, Weight.LIGHT);
        }
        return ItemSize.of(Size.VERY_SMALL, Weight.VERY_LIGHT);
    }

    public static class Packet
    extends DataManagerSyncPacket<ItemSizeDefinition> {
    }
}

