/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.heat;

import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeatHandler
implements ICapabilitySerializable<CompoundTag>,
IHeat {
    private final LazyOptional<IHeat> capability = LazyOptional.of(() -> this);
    private final float forgingTemp;
    private final float weldingTemp;
    protected float heatCapacity;
    protected float temperature;
    protected long lastUpdateTick;

    public HeatHandler(float heatCapacity, float forgingTemp, float weldingTemp) {
        this.heatCapacity = heatCapacity;
        this.forgingTemp = forgingTemp;
        this.weldingTemp = weldingTemp;
    }

    @Override
    public float getTemperature() {
        return HeatCapability.adjustTemp(this.temperature, this.getHeatCapacity(), Calendars.get().getTicks() - this.lastUpdateTick);
    }

    @Override
    public void setTemperature(float temperature) {
        this.temperature = temperature;
        this.lastUpdateTick = Calendars.get().getTicks();
    }

    @Override
    public float getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public float getWorkingTemperature() {
        return this.forgingTemp;
    }

    @Override
    public float getWeldingTemperature() {
        return this.weldingTemp;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == HeatCapability.CAPABILITY || cap == HeatCapability.NETWORK_CAPABILITY) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.getTemperature() <= 0.0f) {
            nbt.m_128356_("ticks", 0L);
            nbt.m_128350_("heat", 0.0f);
        } else {
            nbt.m_128356_("ticks", this.lastUpdateTick);
            nbt.m_128350_("heat", this.temperature);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("heat");
        this.lastUpdateTick = nbt.m_128454_("ticks");
    }

    public void setHeatCapacity(float heatCapacity) {
        if (this.getHeatCapacity() != heatCapacity) {
            this.setTemperature(this.getTemperature());
            this.heatCapacity = heatCapacity;
        }
    }
}

