/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.List;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.INetworkFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.config.FoodExpiryTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public interface IFood
extends INetworkFood {
    public long getCreationDate();

    public void setCreationDate(long var1);

    public long getRottenDate();

    default public boolean isRotten() {
        return this.getRottenDate() < Calendars.get().getTicks();
    }

    default public boolean isTransientNonDecaying() {
        return false;
    }

    public FoodData getData();

    public float getDecayDateModifier();

    public void setNonDecaying();

    public List<FoodTrait> getTraits();

    default public void addTooltipInfo(ItemStack stack, List<Component> text) {
        if (this.isRotten()) {
            text.add((Component)Helpers.translatable("tfc.tooltip.food_rotten").m_130940_(ChatFormatting.RED));
            if (((long)stack.hashCode() * 1928634918231L & 0xFFL) == 0L) {
                text.add((Component)Helpers.translatable("tfc.tooltip.food_rotten_special").m_130940_(ChatFormatting.RED));
            }
        } else {
            long rottenDate = this.getRottenDate();
            if (rottenDate == Long.MAX_VALUE) {
                if (!this.isTransientNonDecaying()) {
                    text.add((Component)Helpers.translatable("tfc.tooltip.food_infinite_expiry").m_130940_(ChatFormatting.GOLD));
                }
            } else {
                TranslatableComponent tooltip;
                long rottenCalendarTime = Calendars.CLIENT.ticksToCalendarTicks(rottenDate);
                long ticksRemaining = rottenDate - Calendars.CLIENT.getTicks();
                switch ((FoodExpiryTooltipStyle)((Object)TFCConfig.CLIENT.foodExpiryTooltipStyle.get())) {
                    case EXPIRY: {
                        TranslatableComponent translatableComponent = Helpers.translatable("tfc.tooltip.food_expiry_date", ICalendar.getTimeAndDate(rottenCalendarTime, Calendars.CLIENT.getCalendarDaysInMonth()));
                        break;
                    }
                    case TIME_LEFT: {
                        TranslatableComponent translatableComponent = Helpers.translatable("tfc.tooltip.food_expiry_left", Calendars.CLIENT.getTimeDelta(ticksRemaining));
                        break;
                    }
                    case BOTH: {
                        TranslatableComponent translatableComponent = Helpers.translatable("tfc.tooltip.food_expiry_date_and_left", ICalendar.getTimeAndDate(rottenCalendarTime, Calendars.CLIENT.getCalendarDaysInMonth()), Calendars.CLIENT.getTimeDelta(ticksRemaining));
                        break;
                    }
                    default: {
                        TranslatableComponent translatableComponent = tooltip = null;
                    }
                }
                if (tooltip != null) {
                    text.add((Component)tooltip.m_130940_(ChatFormatting.DARK_GREEN));
                }
            }
        }
        if (ClientHelpers.hasShiftDown()) {
            text.add((Component)Helpers.translatable("tfc.tooltip.nutrition").m_130940_(ChatFormatting.GRAY));
            boolean any = false;
            if (!this.isRotten()) {
                int water;
                FoodData data = this.getData();
                float saturation = data.saturation();
                if (saturation > 0.0f) {
                    text.add((Component)Helpers.translatable("tfc.tooltip.nutrition_saturation", String.format("%d", (int)(saturation * 5.0f))).m_130940_(ChatFormatting.GRAY));
                    any = true;
                }
                if ((water = (int)data.water()) > 0) {
                    text.add((Component)Helpers.translatable("tfc.tooltip.nutrition_water", String.format("%d", water)).m_130940_(ChatFormatting.GRAY));
                    any = true;
                }
                for (Nutrient nutrient : Nutrient.VALUES) {
                    float value = data.nutrient(nutrient);
                    if (!(value > 0.0f)) continue;
                    text.add((Component)Helpers.literal(" - ").m_7220_((Component)Helpers.translateEnum(nutrient)).m_130946_(": " + String.format("%.1f", Float.valueOf(value))).m_130940_(nutrient.getColor()));
                    any = true;
                }
            }
            if (!any) {
                text.add((Component)Helpers.translatable("tfc.tooltip.nutrition_none").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            text.add((Component)Helpers.translatable("tfc.tooltip.hold_shift_for_nutrition_info").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        for (FoodTrait trait : this.getTraits()) {
            trait.addTooltipInfo(stack, text);
        }
        if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue()) {
            text.add((Component)Helpers.literal(ChatFormatting.DARK_GRAY + "[Debug] Created at: " + this.getCreationDate() + " rots at: " + this.getRottenDate()));
        }
    }
}

