/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FoodTrait {
    private static final BiMap<ResourceLocation, FoodTrait> REGISTRY = HashBiMap.create();
    private final Supplier<Float> decayModifier;
    @Nullable
    private final String translationKey;

    public static synchronized FoodTrait register(ResourceLocation id, FoodTrait trait) {
        if (REGISTRY.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate key: " + id);
        }
        REGISTRY.put((Object)id, (Object)trait);
        return trait;
    }

    @Nullable
    public static FoodTrait getTrait(ResourceLocation key) {
        return (FoodTrait)REGISTRY.get((Object)key);
    }

    public static FoodTrait getTraitOrThrow(ResourceLocation key) {
        return Objects.requireNonNull(FoodTrait.getTrait(key), "No food trait named: " + key);
    }

    public static ResourceLocation getId(FoodTrait trait) {
        return (ResourceLocation)REGISTRY.inverse().get((Object)trait);
    }

    public FoodTrait(float decayModifier, @Nullable String translationKey) {
        this.decayModifier = () -> Float.valueOf(decayModifier);
        this.translationKey = translationKey;
    }

    public FoodTrait(Supplier<Float> decayModifier, @Nullable String translationKey) {
        this.decayModifier = decayModifier;
        this.translationKey = translationKey;
    }

    public float getDecayModifier() {
        return this.decayModifier.get().floatValue();
    }

    public void addTooltipInfo(ItemStack stack, List<Component> text) {
        if (this.translationKey != null) {
            TranslatableComponent component = Helpers.translatable(this.translationKey);
            if (this.decayModifier.get().floatValue() > 1.0f) {
                component.m_130940_(ChatFormatting.RED);
            }
            text.add((Component)component);
        }
    }
}

