/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public record FoodData(int hunger, float water, float saturation, float grain, float fruit, float vegetables, float protein, float dairy, float decayModifier) {
    public static final FoodData EMPTY = new FoodData(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);

    public static FoodData create(int hunger, float water, float saturation, float[] nutrients, float decayModifier) {
        return new FoodData(hunger, water, saturation, nutrients[0], nutrients[1], nutrients[2], nutrients[3], nutrients[4], decayModifier);
    }

    public static FoodData decode(FriendlyByteBuf buffer) {
        int hunger = buffer.m_130242_();
        float saturation = buffer.readFloat();
        float water = buffer.readFloat();
        float decayModifier = buffer.readFloat();
        float[] nutrition = new float[Nutrient.TOTAL];
        for (Nutrient nutrient : Nutrient.VALUES) {
            nutrition[nutrient.ordinal()] = buffer.readFloat();
        }
        return FoodData.create(hunger, water, saturation, nutrition, decayModifier);
    }

    public static FoodData read(JsonObject json) {
        int hunger = JsonHelpers.m_13824_((JsonObject)json, (String)"hunger", (int)4);
        float saturation = JsonHelpers.m_13820_((JsonObject)json, (String)"saturation", (float)0.0f);
        float water = JsonHelpers.m_13820_((JsonObject)json, (String)"water", (float)0.0f);
        float decayModifier = JsonHelpers.m_13820_((JsonObject)json, (String)"decay_modifier", (float)1.0f);
        float[] nutrition = new float[Nutrient.TOTAL];
        for (Nutrient nutrient : Nutrient.VALUES) {
            nutrition[nutrient.ordinal()] = JsonHelpers.m_13820_((JsonObject)json, (String)nutrient.m_7912_(), (float)0.0f);
        }
        return FoodData.create(hunger, water, saturation, nutrition, decayModifier);
    }

    public static FoodData read(CompoundTag nbt) {
        return new FoodData(nbt.m_128451_("food"), nbt.m_128457_("water"), nbt.m_128457_("sat"), nbt.m_128457_("grain"), nbt.m_128457_("fruit"), nbt.m_128457_("veg"), nbt.m_128457_("meat"), nbt.m_128457_("dairy"), nbt.m_128457_("decay"));
    }

    public float nutrient(Nutrient nutrient) {
        return switch (nutrient) {
            default -> throw new IncompatibleClassChangeError();
            case Nutrient.GRAIN -> this.grain;
            case Nutrient.FRUIT -> this.fruit;
            case Nutrient.VEGETABLES -> this.vegetables;
            case Nutrient.PROTEIN -> this.protein;
            case Nutrient.DAIRY -> this.dairy;
        };
    }

    public float[] nutrients() {
        return new float[]{this.grain, this.fruit, this.vegetables, this.protein, this.dairy};
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("food", this.hunger);
        nbt.m_128350_("sat", this.saturation);
        nbt.m_128350_("water", this.water);
        nbt.m_128350_("decay", this.decayModifier);
        nbt.m_128350_("grain", this.grain);
        nbt.m_128350_("veg", this.vegetables);
        nbt.m_128350_("fruit", this.fruit);
        nbt.m_128350_("meat", this.protein);
        nbt.m_128350_("dairy", this.dairy);
        return nbt;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.hunger);
        buffer.writeFloat(this.saturation);
        buffer.writeFloat(this.water);
        buffer.writeFloat(this.decayModifier);
        for (Nutrient nutrient : Nutrient.VALUES) {
            buffer.writeFloat(this.nutrient(nutrient));
        }
    }
}

