/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.egg;

import java.util.Optional;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EggHandler
implements IEgg,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IEgg> capability;
    private final ItemStack stack;
    private boolean fertilized;
    private long hatchDay;
    @Nullable
    private CompoundTag entityTag;
    private boolean initialized;

    public EggHandler(ItemStack itemStack) {
        this.stack = itemStack;
        this.fertilized = false;
        this.hatchDay = 0L;
        this.entityTag = null;
        this.capability = LazyOptional.of(() -> this);
    }

    @Override
    public long getHatchDay() {
        return this.hatchDay;
    }

    @Override
    public Optional<Entity> getEntity(Level level) {
        return this.entityTag != null ? EntityType.m_20642_((CompoundTag)this.entityTag, (Level)level) : Optional.empty();
    }

    @Override
    public boolean isFertilized() {
        return this.fertilized;
    }

    @Override
    public void setFertilized(@NotNull Entity entity, long hatchDay) {
        this.fertilized = true;
        this.entityTag = entity.serializeNBT();
        this.hatchDay = hatchDay;
        this.save();
    }

    @Override
    public void removeFertilization() {
        this.entityTag = null;
        this.fertilized = false;
        this.hatchDay = 0L;
        this.stack.m_41749_("entity");
        this.stack.m_41749_("fertilized");
        this.stack.m_41749_("hatch");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == EggCapability.CAPABILITY) {
            this.load();
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag tag) {
    }

    private void load() {
        if (!this.initialized) {
            this.initialized = true;
            CompoundTag tag = this.stack.m_41784_();
            if (tag.m_128425_("entity", 10)) {
                this.entityTag = tag.m_128469_("entity");
                this.fertilized = tag.m_128471_("fertilized");
                this.hatchDay = tag.m_128454_("hatch");
            } else {
                this.fertilized = false;
                this.entityTag = null;
                this.hatchDay = 0L;
            }
        }
    }

    private void save() {
        CompoundTag tag = this.stack.m_41784_();
        if (this.entityTag != null) {
            tag.m_128365_("entity", (Tag)this.entityTag);
            tag.m_128379_("fertilized", this.fertilized);
            tag.m_128356_("hatch", this.hatchDay);
        }
    }
}

