/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.tree.TFCTreeGrower;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TFCSaplingBlock
extends SaplingBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;
    private final Supplier<Integer> daysToGrow;

    public TFCSaplingBlock(TFCTreeGrower tree, ExtendedProperties properties, int days) {
        this(tree, properties, () -> days);
    }

    public TFCSaplingBlock(TFCTreeGrower tree, ExtendedProperties properties, Supplier<Integer> days) {
        super((AbstractTreeGrower)tree, properties.properties());
        this.properties = properties;
        this.daysToGrow = days;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (level.m_46803_(pos.m_7494_()) >= 9 && random.nextInt(7) == 0) {
            TickCounterBlockEntity counter;
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TickCounterBlockEntity && (double)(counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() > (double)(24000 * this.getDaysToGrow()) * (Double)TFCConfig.SERVER.globalSaplingGrowthModifier.get()) {
                this.m_55980_(level, pos, (BlockState)state.m_61124_((Property)f_55973_, (Comparable)Integer.valueOf(1)), random);
            }
        }
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.m_6402_(level, pos, state, placer, stack);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return super.m_6266_(state, level, pos) || Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public int getDaysToGrow() {
        return this.daysToGrow.get();
    }
}

