/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TFCLeavesBlock
extends Block
implements ILeavesBlock,
IForgeBlockExtension,
IFluidLoggable {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private final int maxDecayDistance;
    private final ExtendedProperties properties;
    @Nullable
    private final Supplier<? extends Block> fallenLeaves;
    @Nullable
    private final Supplier<? extends Block> fallenTwig;

    public static void doParticles(ServerLevel level, double x, double y, double z, int count) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.LEAF.get()), x, y, z, count, (double)Helpers.triangle(level.f_46441_), (double)Helpers.triangle(level.f_46441_), (double)Helpers.triangle(level.f_46441_), (double)0.3f);
    }

    public static void onEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        float modifier = ((Double)TFCConfig.SERVER.leavesMovementModifier.get()).floatValue();
        if (modifier < 1.0f && level.m_6425_(pos).m_76178_()) {
            Helpers.slowEntityInBlock(entity, modifier, 5);
        }
        if (Helpers.isEntity(entity, TFCTags.Entities.DESTROYED_BY_LEAVES)) {
            entity.m_6074_();
        }
        if (level.f_46441_.nextInt(20) == 0 && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            TFCLeavesBlock.doParticles(server, entity.m_20185_(), entity.m_20188_() - 0.25, entity.m_20189_(), 3);
        }
    }

    public static TFCLeavesBlock create(ExtendedProperties properties, int maxDecayDistance) {
        return TFCLeavesBlock.create(properties, maxDecayDistance, null, null);
    }

    public static TFCLeavesBlock create(ExtendedProperties properties, int maxDecayDistance, @Nullable Supplier<? extends Block> fallenLeaves, @Nullable Supplier<? extends Block> fallenTwig) {
        final IntegerProperty distanceProperty = TFCLeavesBlock.getDistanceProperty(maxDecayDistance);
        return new TFCLeavesBlock(properties, maxDecayDistance, fallenLeaves, fallenTwig){

            @Override
            protected IntegerProperty getDistanceProperty() {
                return distanceProperty;
            }
        };
    }

    private static IntegerProperty getDistanceProperty(int maxDecayDistance) {
        if (maxDecayDistance >= 7 && maxDecayDistance < 7 + TFCBlockStateProperties.DISTANCES.length) {
            return TFCBlockStateProperties.DISTANCES[maxDecayDistance - 7 + 1];
        }
        throw new IllegalArgumentException("No property set for distance: " + maxDecayDistance);
    }

    protected TFCLeavesBlock(ExtendedProperties properties, int maxDecayDistance, @Nullable Supplier<? extends Block> fallenLeaves, @Nullable Supplier<? extends Block> fallenTwig) {
        super(properties.properties());
        this.maxDecayDistance = maxDecayDistance;
        this.properties = properties;
        this.fallenLeaves = fallenLeaves;
        this.fallenTwig = fallenTwig;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getDistanceProperty(), (Comparable)Integer.valueOf(1))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        int distance = this.getDistance(facingState) + 1;
        if (distance != 1 || (Integer)state.m_61143_((Property)this.getDistanceProperty()) != distance) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        super.m_7455_(state, level, pos, rand);
        if ((Integer)state.m_61143_((Property)this.getDistanceProperty()) > this.maxDecayDistance && !((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            level.m_7471_(pos, false);
            if (rand.nextFloat() < 0.01f) {
                this.createDestructionEffects(state, level, pos, rand, false);
            }
            TFCLeavesBlock.doParticles(level, (float)pos.m_123341_() + rand.nextFloat(), (float)pos.m_123342_() + rand.nextFloat(), (float)pos.m_123343_() + rand.nextFloat(), 1);
        } else if (rand.nextFloat() < 1.0E-4f && Calendars.SERVER.getCalendarMonthOfYear().getSeason() == Season.FALL) {
            this.createDestructionEffects(state, level, pos, rand, true);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        int oldDistance = (Integer)state.m_61143_((Property)this.getDistanceProperty());
        int distance = this.updateDistance((LevelAccessor)level, pos);
        if (distance > this.maxDecayDistance) {
            if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
                if (!((Boolean)TFCConfig.SERVER.enableLeavesDecaySlowly.get()).booleanValue()) {
                    level.m_7471_(pos, false);
                    if (rand.nextFloat() < 0.01f) {
                        this.createDestructionEffects(state, level, pos, rand, false);
                    }
                    TFCLeavesBlock.doParticles(level, (float)pos.m_123341_() + rand.nextFloat(), (float)pos.m_123342_() + rand.nextFloat(), (float)pos.m_123343_() + rand.nextFloat(), 1);
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.getDistanceProperty(), (Comparable)Integer.valueOf(this.maxDecayDistance + 1)));
                }
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getDistanceProperty(), (Comparable)Integer.valueOf(this.maxDecayDistance)), 3);
            }
        } else if (distance != oldDistance) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getDistanceProperty(), (Comparable)Integer.valueOf(distance)), 3);
        }
    }

    public void createDestructionEffects(BlockState state, ServerLevel level, BlockPos pos, Random random, boolean replaceOnlyAir) {
        BlockState twig = this.getFallenTwig();
        BlockState leaf = this.getFallenLeaves();
        if (twig == null && leaf == null) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122190_((Vec3i)pos);
        BlockState stateAt = Blocks.f_50016_.m_49966_();
        while (stateAt.m_60734_() instanceof ILeavesBlock || LegacyMaterials.isReplaceable(stateAt)) {
            cursor.m_122184_(0, -1, 0);
            stateAt = level.m_8055_((BlockPos)cursor);
        }
        cursor.m_122184_(0, 1, 0);
        stateAt = level.m_8055_((BlockPos)cursor);
        if (LegacyMaterials.isReplaceable(stateAt)) {
            BlockState placeState;
            BlockState blockState = placeState = twig == null ? leaf : twig;
            if (leaf != null && twig != null && random.nextFloat() < 0.5f) {
                placeState = leaf;
            }
            if (placeState.m_60710_((LevelReader)level, (BlockPos)cursor)) {
                if (replaceOnlyAir && !stateAt.m_60795_()) {
                    return;
                }
                level.m_46597_((BlockPos)cursor, placeState);
            }
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        TFCLeavesBlock.onEntityInside(state, level, pos, entity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(context.m_43723_() != null))).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PERSISTENT, this.getDistanceProperty(), this.getFluidProperty()});
    }

    @Nullable
    public BlockState getFallenLeaves() {
        return this.fallenLeaves == null ? null : this.fallenLeaves.get().m_49966_();
    }

    @Nullable
    public BlockState getFallenTwig() {
        return this.fallenTwig == null ? null : this.fallenTwig.get().m_49966_();
    }

    protected abstract IntegerProperty getDistanceProperty();

    private int updateDistance(LevelAccessor level, BlockPos pos) {
        int distance = 1 + this.maxDecayDistance;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Helpers.DIRECTIONS) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(direction);
            distance = Math.min(distance, this.getDistance(level.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return distance;
    }

    private int getDistance(BlockState neighbor) {
        if (Helpers.isBlock(neighbor.m_60734_(), (TagKey<Block>)BlockTags.f_13106_)) {
            return 0;
        }
        return neighbor.m_60734_() == this ? (Integer)neighbor.m_61143_((Property)this.getDistanceProperty()) : this.maxDecayDistance;
    }
}

