/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class LogBlock
extends RotatedPillarBlock
implements IForgeBlockExtension {
    public static final BooleanProperty NATURAL = TFCBlockStateProperties.NATURAL;
    @Nullable
    private final Supplier<? extends Block> stripped;
    private final ExtendedProperties properties;

    public LogBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> stripped) {
        super(properties.properties());
        this.stripped = stripped;
        this.properties = properties;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float baseSpeed = (float)((Boolean)state.m_61143_((Property)NATURAL) != false ? 2 : 1) * state.m_60800_(level, pos);
        if (baseSpeed == -1.0f) {
            return 0.0f;
        }
        int toolModifier = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / baseSpeed / (float)toolModifier;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{NATURAL}));
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction action, boolean simulate) {
        if (context.m_43722_().canPerformAction(action) && action == ToolActions.AXE_STRIP && this.stripped != null) {
            return Helpers.copyProperties(this.stripped.get().m_49966_(), state);
        }
        return null;
    }
}

