/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaPlantBlock
extends SeasonalPlantBlock
implements IBushBlock,
HoeOverlayBlock {
    public static final VoxelShape PLANT = BananaPlantBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape TRUNK_0 = BananaPlantBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TRUNK_1 = BananaPlantBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public static void kill(Level level, BlockPos pos) {
        Block deadBlock = (Block)TFCBlocks.DEAD_BANANA_PLANT.get();
        if (!level.f_46443_) {
            BlockState foundState;
            BlockState deadState = deadBlock.m_49966_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
            while ((foundState = level.m_8055_((BlockPos)mutable)).m_60713_((Block)TFCBlocks.BANANA_PLANT.get())) {
                level.m_46597_((BlockPos)mutable, (BlockState)deadState.m_61124_((Property)STAGE, (Comparable)((Integer)foundState.m_61143_((Property)STAGE))));
                mutable.m_122173_(Direction.DOWN);
            }
        }
    }

    public BananaPlantBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages) {
        super(properties, ClimateRanges.BANANA_PLANT, productItem, stages);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult res = super.m_6227_(state, level, pos, player, hand, hit);
        if (res.m_19077_()) {
            BananaPlantBlock.kill(level, pos);
        }
        return res;
    }

    @Override
    public BlockState stateAfterPicking(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BANANA_PLANT.get()).m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = (ClimateRange)this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos, range, false, FruitTreeLeavesBlock.getHydration(level, pos)));
        text.add(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
    }

    @Override
    public ItemStack getProductItem(Random random) {
        return new ItemStack((ItemLike)this.productItem.get(), Mth.m_14072_((Random)random, (int)3, (int)6));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)STAGE)) {
            case 0 -> TRUNK_0;
            case 1 -> TRUNK_1;
            default -> PLANT;
        };
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)STAGE) == 2 ? Shapes.m_83040_() : this.m_5940_(state, level, pos, context);
    }

    @Override
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE));
            if (!BananaPlantBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth())) {
                BlockState newState;
                long deltaTicks = Math.min(bush.getTicksSinceBushUpdate(), Calendars.SERVER.getCalendarTicksInYear());
                long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
                long nextCalendarTick = currentCalendarTick - deltaTicks;
                ClimateRange range = (ClimateRange)this.climateRange.get();
                int hydration = FruitTreeLeavesBlock.getHydration(level, pos);
                int stage = (Integer)state.m_61143_((Property)STAGE);
                BlockPos abovePos = pos.m_7494_();
                do {
                    nextCalendarTick = Math.min(nextCalendarTick + Calendars.SERVER.getCalendarTicksInMonth(), currentCalendarTick);
                    if (currentLifecycle.active() && stage < 2) {
                        BlockPos downPos = pos.m_6625_(3);
                        if (!Helpers.isBlock(level.m_8055_(abovePos), (Block)this) && (level.f_46441_.nextInt(4) == 0 || Helpers.isBlock(level.m_8055_(downPos), (Block)this))) {
                            ++stage;
                        }
                    }
                    float temperatureAtNextTick = Climate.getTemperature(level, pos, nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth());
                    Lifecycle lifecycleAtNextTick = this.getLifecycleForMonth(ICalendar.getMonthOfYear(nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth()));
                    currentLifecycle = range.checkBoth(hydration, temperatureAtNextTick, false) ? currentLifecycle.advanceTowards(lifecycleAtNextTick) : Lifecycle.DORMANT;
                    if (stage < 2 && currentLifecycle.active()) {
                        currentLifecycle = Lifecycle.HEALTHY;
                    }
                    newState = (BlockState)((BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage))).m_61124_((Property)LIFECYCLE, (Comparable)((Object)currentLifecycle));
                    if (stage >= 2 || !currentLifecycle.active() || !level.m_46859_(abovePos) || !level.m_45527_(abovePos)) continue;
                    level.m_46597_(abovePos, newState);
                    long newBushTicks = nextCalendarTick;
                    level.m_141902_(abovePos, (BlockEntityType)TFCBlockEntities.BERRY_BUSH.get()).ifPresent(newBush -> newBush.setLastBushTick(newBushTicks));
                } while (nextCalendarTick < currentCalendarTick);
                if (state != newState) {
                    level.m_46597_(pos, newState);
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if ((Integer)state.m_61143_((Property)STAGE) == 2 && newState.m_60795_()) {
            BananaPlantBlock.kill(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return Helpers.isBlock(belowState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || Helpers.isBlock(belowState, (Block)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)TFCBlocks.BANANA_SAPLING.get());
    }
}

