/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.coral.CoralWallFanBlock;
import net.dries007.tfc.common.blocks.plant.coral.LivingCoralPlantBlock;
import net.dries007.tfc.common.blocks.plant.coral.LivingCoralWallFanBlock;
import net.dries007.tfc.common.blocks.plant.coral.TFCCoralPlantBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;

public enum Coral {
    TUBE(MaterialColor.f_76361_),
    BRAIN(MaterialColor.f_76418_),
    BUBBLE(MaterialColor.f_76422_),
    FIRE(MaterialColor.f_76364_),
    HORN(MaterialColor.f_76416_);

    private final MaterialColor material;

    private Coral(MaterialColor material) {
        this.material = material;
    }

    public static enum BlockType {
        DEAD_CORAL((color, type) -> new TFCCoralPlantBlock(TFCCoralPlantBlock.BIG_SHAPE, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60910_().m_60966_())),
        CORAL((color, type) -> new LivingCoralPlantBlock(TFCCoralPlantBlock.BIG_SHAPE, (Supplier)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL), BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)color.material).m_60910_().m_60966_().m_60918_(SoundType.f_56752_))),
        DEAD_CORAL_FAN((color, type) -> new TFCCoralPlantBlock(TFCCoralPlantBlock.SMALL_SHAPE, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60910_().m_60966_())),
        CORAL_FAN((color, type) -> new LivingCoralPlantBlock(TFCCoralPlantBlock.SMALL_SHAPE, (Supplier)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_FAN), BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)color.material).m_60910_().m_60966_().m_60918_(SoundType.f_56752_))),
        DEAD_CORAL_WALL_FAN((color, type) -> new CoralWallFanBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60910_().m_60966_().lootFrom((Supplier)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_FAN)))),
        CORAL_WALL_FAN((color, type) -> new LivingCoralWallFanBlock((Supplier)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_WALL_FAN), BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)color.material).m_60910_().m_60966_().m_60918_(SoundType.f_56752_).lootFrom((Supplier)TFCBlocks.CORAL.get(color).get((Object)CORAL_FAN))));

        private final BiFunction<Coral, BlockType, ? extends Block> factory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;

        private BlockType(BiFunction<Coral, BlockType, ? extends Block> factory) {
            this(factory, BlockItem::new);
        }

        private BlockType(BiFunction<Coral, BlockType, ? extends Block> factory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.factory = factory;
            this.blockItemFactory = blockItemFactory;
        }

        public boolean needsItem() {
            return this == DEAD_CORAL || this == CORAL;
        }

        public Supplier<Block> create(Coral color) {
            return () -> this.factory.apply(color, this);
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return this.needsItem() ? block -> this.blockItemFactory.apply((Block)block, properties) : null;
        }
    }
}

