/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.common.blocks.plant.ShortGrassBlock;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TFCTallGrassBlock
extends ShortGrassBlock
implements ITallPlant {
    protected static final EnumProperty<ITallPlant.Part> PART = TFCBlockStateProperties.TALL_PLANT_PART;
    protected static final VoxelShape PLANT_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHORTER_PLANT_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);

    public static TFCTallGrassBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new TFCTallGrassBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected TFCTallGrassBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)ITallPlant.Part.LOWER)));
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos newPos;
        super.m_7455_(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random) && state.m_61143_(PART) == ITallPlant.Part.LOWER && (newPos = PlantRegrowth.spreadSelf(state, level, pos, random, 2, 2, 4)) != null && level.m_8055_(newPos.m_7494_()).m_60795_()) {
            this.placeTwoHalves((LevelAccessor)level, newPos, 2, random);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        ITallPlant.Part part = (ITallPlant.Part)((Object)state.m_61143_(PART));
        if (facing.m_122434_() != Direction.Axis.Y || part == ITallPlant.Part.LOWER != (facing == Direction.UP) || facingState.m_60734_() == this && facingState.m_61143_(PART) != part) {
            return part == ITallPlant.Part.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_(PART) == ITallPlant.Part.LOWER) {
            return super.m_7898_(state, level, pos);
        }
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return blockstate.m_60734_() == this && blockstate.m_61143_(PART) == ITallPlant.Part.LOWER;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return pos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context) ? super.m_5573_(context) : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PART}));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_46597_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)ITallPlant.Part.UPPER)));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                BlockPos blockpos;
                BlockState blockstate;
                if (state.m_61143_(PART) == ITallPlant.Part.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(PART) == ITallPlant.Part.LOWER) {
                    level.m_7731_(blockpos, level.m_6425_(blockpos).m_76188_(), 35);
                    level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
                }
            } else {
                TFCTallGrassBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), tile, stack);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ITallPlant.Part part = (ITallPlant.Part)((Object)state.m_61143_(PART));
        if (part == ITallPlant.Part.LOWER) {
            return PLANT_SHAPE;
        }
        return SHORTER_PLANT_SHAPE;
    }

    @Override
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XYZ;
    }

    public void placeTwoHalves(LevelAccessor world, BlockPos pos, int flags, Random random) {
        int age = random.nextInt(3) + 1;
        world.m_7731_(pos, this.updateStateWithCurrentMonth((BlockState)((BlockState)this.m_49966_().m_61124_(TFCBlockStateProperties.TALL_PLANT_PART, (Comparable)((Object)ITallPlant.Part.LOWER))).m_61124_((Property)TFCBlockStateProperties.AGE_3, (Comparable)Integer.valueOf(age))), flags);
        world.m_7731_(pos.m_7494_(), this.updateStateWithCurrentMonth((BlockState)((BlockState)this.m_49966_().m_61124_(TFCBlockStateProperties.TALL_PLANT_PART, (Comparable)((Object)ITallPlant.Part.UPPER))).m_61124_((Property)TFCBlockStateProperties.AGE_3, (Comparable)Integer.valueOf(age))), flags);
    }
}

