/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCKelpTopBlock
extends TopPlantBlock
implements IFluidLoggable {
    private final Supplier<? extends Block> bodyBlock;

    public static TFCKelpTopBlock create(BlockBehaviour.Properties properties, Supplier<? extends Block> bodyBlock, Direction direction, VoxelShape shape, final FluidProperty fluid) {
        return new TFCKelpTopBlock(ExtendedProperties.of(properties), bodyBlock, direction, shape){

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TFCKelpTopBlock(ExtendedProperties properties, Supplier<? extends Block> bodyBlock, Direction direction, VoxelShape shape) {
        super(properties, bodyBlock, direction, shape);
        this.bodyBlock = bodyBlock;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState;
        Level level = context.m_43725_();
        BlockState state = super.m_5573_(context);
        if (state != null && !(fluidState = level.m_6425_(context.m_8083_())).m_76178_() && this.getFluidProperty().canContain(fluidState.m_76152_())) {
            return (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return null;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_60819_().m_76178_()) {
            return false;
        }
        return super.m_7898_(state, level, pos);
    }

    protected boolean m_142209_(BlockState state) {
        return state.m_60734_() != Blocks.f_50450_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelshape = super.m_5940_(state, level, pos, context);
        Vec3 vector3d = state.m_60824_(level, pos);
        return voxelshape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.f_53859_.m_122424_() && !state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        if (facing != this.f_53859_ || !Helpers.isBlock(facingState, (Block)this) && !Helpers.isBlock(facingState, (Block)this.getBodyBlock())) {
            FluidHelpers.tickFluid(level, currentPos, state);
            return state;
        }
        return (BlockState)this.getBodyBlock().m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getFluidProperty()});
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    @Override
    protected boolean m_5971_(BlockState state) {
        Fluid fluid = state.m_60819_().m_76152_();
        return this.getFluidProperty().canContain(fluid) && fluid != Fluids.f_76191_;
    }

    protected GrowingPlantBodyBlock getBodyBlock() {
        return (GrowingPlantBodyBlock)this.bodyBlock.get();
    }
}

