/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PlantBlock
extends TFCBushBlock {
    public static final IntegerProperty AGE = TFCBlockStateProperties.AGE_3;
    protected static final VoxelShape PLANT_SHAPE = PlantBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public static PlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    public static PlantBlock createFlat(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){
            static final VoxelShape SHAPE = 2.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
                return SHAPE;
            }
        };
    }

    protected PlantBlock(ExtendedProperties properties) {
        super(properties);
        BlockState stateDefinition = (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
        IntegerProperty stageProperty = this.getPlant().getStageProperty();
        if (stageProperty != null) {
            stateDefinition = (BlockState)stateDefinition.m_61124_((Property)stageProperty, (Comparable)Integer.valueOf(0));
        }
        this.m_49959_(stateDefinition);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (random.nextInt(400) == 0 && Helpers.isBlock(state, (TagKey<Block>)BlockTags.f_13041_) && Calendars.CLIENT.getCalendarMonthOfYear().getSeason() == Season.SPRING) {
            level.m_7106_((ParticleOptions)TFCParticles.BUTTERFLY.get(), (double)((float)pos.m_123341_() + random.nextFloat()), (double)((float)pos.m_123342_() + random.nextFloat()), (double)((float)pos.m_123343_() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PLANT_SHAPE;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        int newStage;
        int stage;
        IntegerProperty stageProp;
        boolean dirty = false;
        int age = (Integer)state.m_61143_((Property)AGE);
        if (random.nextDouble() < (Double)TFCConfig.SERVER.plantGrowthChance.get() && age < 3) {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            dirty = true;
        }
        if ((stageProp = this.getPlant().getStageProperty()) != null && (stage = ((Integer)state.m_61143_((Property)stageProp)).intValue()) != (newStage = this.getPlant().stageFor(Calendars.SERVER.getCalendarMonthOfYear()))) {
            state = (BlockState)state.m_61124_((Property)stageProp, (Comparable)Integer.valueOf(newStage));
            dirty = true;
        }
        if (dirty) {
            level.m_46597_(pos, this.updateStateWithCurrentMonth(state));
        }
    }

    public abstract RegistryPlant getPlant();

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateStateWithCurrentMonth(this.m_49966_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.getPlant().getStageProperty() != null) {
            builder.m_61104_(new Property[]{this.getPlant().getStageProperty()});
        }
        builder.m_61104_(new Property[]{AGE});
    }

    public float m_49961_() {
        float modifier = ((Double)TFCConfig.SERVER.plantsMovementModifier.get()).floatValue();
        return Helpers.lerp(modifier, this.f_60448_, 1.0f);
    }

    protected BlockState updateStateWithCurrentMonth(BlockState state) {
        return this.getPlant().getStageProperty() != null ? (BlockState)state.m_61124_((Property)this.getPlant().getStageProperty(), (Comparable)Integer.valueOf(this.getPlant().stageFor(Calendars.SERVER.getCalendarMonthOfYear()))) : state;
    }
}

