/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SealableDeviceBlock
extends DeviceBlock
implements IItemSize,
TooltipBlock {
    public static final BooleanProperty SEALED = TFCBlockStateProperties.SEALED;
    public static final BooleanProperty POWERED = TFCBlockStateProperties.POWERED;
    private static final VoxelShape SHAPE = SealableDeviceBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_UNSEALED = Shapes.m_83113_((VoxelShape)SHAPE, (VoxelShape)SealableDeviceBlock.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.f_82685_);
    private static final int[] IMAGE_TOOLTIP = new int[]{1, 1, 0, 0};

    public SealableDeviceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SEALED) != false ? SHAPE : SHAPE_UNSEALED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean powered = context.m_43725_().m_46753_(context.m_8083_());
        return (BlockState)(context.m_43722_().m_41783_() != null ? (BlockState)this.m_49966_().m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(true)) : this.m_49966_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            if (!Helpers.isEmpty((IItemHandler)inventory) && !((Boolean)TFCConfig.CLIENT.displayItemContentsAsImages.get()).booleanValue()) {
                tooltip.add((Component)Helpers.translatable("tfc.tooltip.contents").m_130940_(ChatFormatting.DARK_GREEN));
                Helpers.addInventoryTooltipInfo((IItemHandler)inventory, tooltip);
            }
            this.addExtraInfo(tooltip, inventoryTag);
        }
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag tag;
        if (((Boolean)TFCConfig.CLIENT.displayItemContentsAsImages.get()).booleanValue() && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            if (!Helpers.isEmpty((IItemHandler)inventory)) {
                int[] params = this.getImageTooltipParameters();
                return Helpers.getTooltipImage((IItemHandler)inventory, params[0], params[1], params[2], params[3]);
            }
        }
        return Optional.empty();
    }

    public int[] getImageTooltipParameters() {
        return IMAGE_TOOLTIP;
    }

    protected void addExtraInfo(List<Component> tooltip, CompoundTag inventoryTag) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{SEALED, POWERED}));
    }

    @Override
    public Size getSize(ItemStack stack) {
        return Size.HUGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return stack.m_41783_() == null ? Weight.HEAVY : Weight.VERY_HEAVY;
    }

    @Override
    public int getDefaultStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity entity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (((Boolean)state.m_61143_((Property)SEALED)).booleanValue() && (entity = level.m_7702_(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.m_187476_(stack);
        }
        return stack;
    }

    @Override
    protected void beforeRemove(InventoryBlockEntity<?> entity) {
        if (!((Boolean)entity.m_58900_().m_61143_((Property)SEALED)).booleanValue()) {
            entity.ejectInventory();
        }
        entity.invalidateCapabilities();
    }

    public void handleNeighborChanged(BlockState state, Level level, BlockPos pos, Runnable onSeal, Runnable onUnseal) {
        boolean signal = level.m_46753_(pos);
        if (signal != (Boolean)state.m_61143_((Property)POWERED)) {
            if (signal != (Boolean)state.m_61143_((Property)SEALED)) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal))).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(signal)));
                if (signal) {
                    onSeal.run();
                } else {
                    onUnseal.run();
                }
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal)));
            }
        }
    }
}

