/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngotPileBlock
extends ExtendedBlock
implements EntityBlockExtension {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_64;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)2.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)4.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)6.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)8.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)10.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)12.0, (double)15.75), IngotPileBlock.m_49796_((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)14.0, (double)15.75), Shapes.m_83144_()};

    public IngotPileBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_()) && !Helpers.isBlock(neighborState, this)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_()) {
            BlockPos topPos = pos;
            while (Helpers.isBlock(level.m_8055_(topPos.m_7494_()), this)) {
                topPos = topPos.m_7494_();
            }
            BlockState topState = level.m_8055_(topPos);
            int topIngots = (Integer)topState.m_61143_((Property)COUNT);
            level.m_141902_(topPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(pile -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)pile.removeIngot()));
            if (topIngots == 1) {
                level.m_7471_(topPos, false);
            } else {
                level.m_7731_(topPos, (BlockState)topState.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(topIngots - 1)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos adjacentPos = pos.m_7495_();
        BlockState adjacentState = level.m_8055_(adjacentPos);
        return adjacentState.m_60783_((BlockGetter)level, adjacentPos, Direction.UP) || Helpers.isBlock(adjacentState, this);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        boolean canActuallyHarvest = state.canHarvestBlock((BlockGetter)level, pos, player);
        if (player.m_7500_() && canActuallyHarvest && (blockEntity = level.m_7702_(pos)) instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
            pile.removeAllIngots();
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
            if (newState.m_60734_() != this) {
                pile.removeAllIngots().forEach(ingot -> IngotPileBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)ingot));
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{COUNT}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Integer)state.m_61143_((Property)COUNT) - 1) / 8];
    }
}

