/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FirepitBlock
extends BottomSupportedDeviceBlock
implements IGhostBlockHandler,
IBellowsConsumer {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty SMOKE_LEVEL = TFCBlockStateProperties.SMOKE_LEVEL;
    public static final VoxelShape BASE_SHAPE = Shapes.m_83110_((VoxelShape)FirepitBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)FirepitBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));

    public FirepitBlock(ExtendedProperties properties) {
        this(properties, BASE_SHAPE);
    }

    public FirepitBlock(ExtendedProperties properties, VoxelShape shape) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, shape);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SMOKE_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            Helpers.fireSpreaderTick(level, pos, random, 2);
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        int i;
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + this.getParticleHeightOffset();
        double z = (double)pos.m_123343_() + 0.5;
        int smoke = (Integer)state.m_61143_((Property)SMOKE_LEVEL);
        if (rand.nextInt(10) == 0) {
            level.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
        }
        for (i = 0; i < 1 + rand.nextInt(3); ++i) {
            level.m_7107_((ParticleOptions)TFCParticles.SMOKES.get(smoke).get(), x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.07, 0.0);
        }
        for (i = 0; i < rand.nextInt(4 + smoke); ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
        if (rand.nextInt(8 - smoke) == 1) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && ((Boolean)level.m_8055_(pos).m_61143_((Property)LIT)).booleanValue()) {
            TFCDamageSources.hotFloor(entity, 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState lookState, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        if (Helpers.isItem(item, (Item)TFCItems.POT.get())) {
            return (BlockState)((Block)TFCBlocks.POT.get()).m_49966_().m_61124_((Property)LIT, (Comparable)((Boolean)lookState.m_61143_((Property)LIT)));
        }
        if (Helpers.isItem(item, (Item)TFCItems.WROUGHT_IRON_GRILL.get())) {
            return (BlockState)((Block)TFCBlocks.GRILL.get()).m_49966_().m_61124_((Property)LIT, (Comparable)((Boolean)lookState.m_61143_((Property)LIT)));
        }
        return null;
    }

    @Override
    public float alpha() {
        return 0.33f;
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.FIREPIT.get()).ifPresent(firepit -> firepit.intakeAir(amount));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, SMOKE_LEVEL});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        AbstractFirepitBlockEntity firepit = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.FIREPIT.get()).orElse(null);
        if (firepit != null) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == TFCItems.POT.get() || stack.m_41720_() == TFCItems.WROUGHT_IRON_GRILL.get()) {
                if (!level.f_46443_) {
                    Block newBlock = stack.m_41720_() == TFCItems.POT.get() ? (Block)TFCBlocks.POT.get() : (Block)TFCBlocks.GRILL.get();
                    AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, firepit, newBlock);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        TFCAdvancements.FIREPIT_CREATED.trigger(serverPlayer, newBlock.m_49966_());
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.EXTINGUISHER) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                firepit.extinguish(state);
                return InteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)firepit, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected double getParticleHeightOffset() {
        return 0.35;
    }
}

