/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DryingBricksBlock
extends BottomSupportedDeviceBlock {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_4;
    public static final BooleanProperty DRIED = TFCBlockStateProperties.DRIED;
    public static final VoxelShape SHAPE_1 = DryingBricksBlock.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)6.0, (double)3.0, (double)7.0);
    public static final VoxelShape SHAPE_2 = Shapes.m_83110_((VoxelShape)SHAPE_1, (VoxelShape)DryingBricksBlock.m_49796_((double)10.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)7.0));
    public static final VoxelShape SHAPE_3 = Shapes.m_83110_((VoxelShape)SHAPE_2, (VoxelShape)DryingBricksBlock.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)6.0, (double)3.0, (double)15.0));
    public static final VoxelShape SHAPE_4 = Shapes.m_83110_((VoxelShape)SHAPE_3, (VoxelShape)DryingBricksBlock.m_49796_((double)10.0, (double)0.0, (double)9.0, (double)14.0, (double)3.0, (double)15.0));
    private final Supplier<? extends Item> dryItem;

    public DryingBricksBlock(ExtendedProperties properties, Supplier<? extends Item> dryItem) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP, SHAPE_1);
        this.dryItem = dryItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)DRIED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (Helpers.isItem(held, this.m_5456_()) && !player.m_6144_() && !((Boolean)state.m_61143_((Property)DRIED)).booleanValue()) {
            int count = (Integer)state.m_61143_((Property)COUNT);
            if (count < 4) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count + 1)));
                this.playSound(state, level, pos, (Entity)player);
                TickCounterBlockEntity.reset(level, pos);
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (held.m_41619_() && player.m_6144_()) {
            int count = (Integer)state.m_61143_((Property)COUNT);
            ItemStack drop = new ItemStack((ItemLike)((Boolean)state.m_61143_((Property)DRIED) != false ? (ItemLike)this.dryItem.get() : this.m_5456_()));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
            if (count > 1) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count - 1)));
            } else {
                level.m_46597_(pos, state.m_60819_().m_76188_());
            }
            this.playSound(state, level, pos, (Entity)player);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!state.m_60819_().m_76178_()) {
            return null;
        }
        if (state.m_60734_() == this && !((Boolean)state.m_61143_((Property)DRIED)).booleanValue() && (Integer)state.m_61143_((Property)COUNT) < 4) {
            return (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)COUNT) + 1));
        }
        return super.m_5573_(context);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)state.m_61143_((Property)DRIED) != false ? this.dryItem.get().m_7968_() : super.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && Helpers.isItem(context.m_43722_(), this.m_5456_()) && (Integer)state.m_61143_((Property)COUNT) < 4 && (Boolean)state.m_61143_((Property)DRIED) == false || super.m_6864_(state, context);
    }

    private void playSound(BlockState state, Level level, BlockPos pos, @Nullable Entity entity) {
        SoundType soundType = this.getSoundType(state, (LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.m_6402_(level, pos, state, placer, stack);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)COUNT)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            default -> SHAPE_1;
        };
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)DRIED) == false;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)DRIED)).booleanValue()) {
            return;
        }
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
            if (level.m_46758_(pos.m_7494_())) {
                counter.resetCounter();
            } else {
                int ticks = (Integer)TFCConfig.SERVER.mudBricksTicks.get();
                if (ticks > -1 && counter.getTicksSinceUpdate() > (long)ticks) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)DRIED, (Comparable)Boolean.valueOf(true)));
                    BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
                    for (Direction d : Direction.Plane.HORIZONTAL) {
                        cursor.m_122159_((Vec3i)pos, d);
                        BlockState stateAt = level.m_8055_((BlockPos)cursor);
                        if (!(stateAt.m_60734_() instanceof DryingBricksBlock)) continue;
                        level.m_186460_((BlockPos)cursor, stateAt.m_60734_(), 1);
                    }
                }
            }
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{COUNT, DRIED}));
    }
}

