/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BurningLogPileBlockEntity;
import net.dries007.tfc.common.blockentities.LogPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class BurningLogPileBlock
extends BaseEntityBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static void tryLightLogPile(Level level, BlockPos pos) {
        LogPileBlockEntity pile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).orElse(null);
        if (pile != null) {
            int logs = pile.logCount();
            pile.m_6211_();
            level.m_46597_(pos, ((Block)TFCBlocks.BURNING_LOG_PILE.get()).m_49966_());
            Helpers.playSound(level, pos, SoundEvents.f_11705_);
            BurningLogPileBlockEntity burningPile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BURNING_LOG_PILE.get()).orElse(null);
            if (burningPile != null) {
                burningPile.light(logs);
                BurningLogPileBlock.tryLightNearby(level, pos);
            }
        }
    }

    private static boolean isValidCoverBlock(BlockState offsetState, Level world, BlockPos pos, Direction side) {
        if (Helpers.isBlock(offsetState, TFCTags.Blocks.CHARCOAL_COVER_WHITELIST)) {
            return true;
        }
        return !LegacyMaterials.isFlammable(offsetState) && offsetState.m_60783_((BlockGetter)world, pos, side);
    }

    private static void tryLightNearby(Level world, BlockPos pos) {
        if (world.m_5776_()) {
            return;
        }
        for (Direction side : Helpers.DIRECTIONS) {
            BlockPos offsetPos = pos.m_142300_(side);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (BurningLogPileBlock.isValidCoverBlock(offsetState, world, offsetPos, side.m_122424_())) {
                if (!Helpers.isBlock(offsetState, (Block)TFCBlocks.LOG_PILE.get())) continue;
                BurningLogPileBlock.tryLightLogPile(world, offsetPos);
                continue;
            }
            if (offsetState.m_60795_()) {
                world.m_46597_(offsetPos, Blocks.f_50083_.m_49966_());
                continue;
            }
            if (world.f_46441_.nextInt(7) != 0) continue;
            world.m_46597_(pos, Blocks.f_50083_.m_49966_());
            return;
        }
    }

    public BurningLogPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        BurningLogPileBlock.tryLightNearby((Level)world, pos);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        double x = (float)pos.m_123341_() + rand.nextFloat();
        double y = pos.m_123342_() + 1;
        double z = (float)pos.m_123343_() + rand.nextFloat();
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, (double)(0.1f + 0.1f * rand.nextFloat()), 0.0);
        if (rand.nextInt(12) == 0) {
            worldIn.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
        }
        for (int i = 0; i < rand.nextInt(3); ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, (double)((0.5f - rand.nextFloat()) / 10.0f), (double)(0.1f + rand.nextFloat() / 8.0f), (double)((0.5f - rand.nextFloat()) / 10.0f));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42414_);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

