/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeadCropBlock
extends TFCBushBlock
implements HoeOverlayBlock {
    public static final BooleanProperty MATURE = TFCBlockStateProperties.MATURE;
    private final Supplier<ClimateRange> climateRange;

    public DeadCropBlock(ExtendedProperties properties, Crop crop) {
        this(properties, crop.getClimateRange());
    }

    public DeadCropBlock(ExtendedProperties properties, Supplier<ClimateRange> range) {
        super(properties);
        this.climateRange = range;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos.m_7495_(), range, false));
        text.add(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
        if (((Boolean)state.m_61143_((Property)MATURE)).booleanValue()) {
            text.add((Component)Helpers.translatable("tfc.tooltip.farmland.mature"));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MATURE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)MATURE) != false ? CropBlock.FULL_SHAPE : CropBlock.QUARTER_SHAPE;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }
}

