/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.StainedWattleBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class WattleBlock
extends StainedWattleBlock
implements IGhostBlockHandler,
IFluidLoggable {
    public static final BooleanProperty WOVEN = TFCBlockStateProperties.WATTLE_WOVEN;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;

    public WattleBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WOVEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() != Fluids.f_76191_) {
            return InteractionResult.PASS;
        }
        ItemStack item = player.m_21120_(hand);
        boolean woven = (Boolean)state.m_61143_((Property)WOVEN);
        if (!woven && Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN) && item.m_41613_() >= 4) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, (BlockState)state.m_61124_((Property)WOVEN, (Comparable)Boolean.valueOf(true)), player, item, 4);
        }
        if (woven && Helpers.isItem(item, TFCTags.Items.DAUB)) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_DAUBED.get());
            return this.setState(level, pos, ((Block)TFCBlocks.UNSTAINED_WATTLE.get()).m_152465_(state), player, item, 1);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState lookState, Direction direction, BlockPos lookPos, double x, double y, double z, ItemStack item) {
        if (((FluidProperty.FluidKey)lookState.m_61143_((Property)this.getFluidProperty())).getFluid() != Fluids.f_76191_) {
            return null;
        }
        boolean woven = (Boolean)lookState.m_61143_((Property)WOVEN);
        if (!woven && Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN) && item.m_41613_() >= 4) {
            return (BlockState)lookState.m_61124_((Property)WOVEN, (Comparable)Boolean.valueOf(true));
        }
        if (woven && Helpers.isItem(item, TFCTags.Items.DAUB)) {
            return ((Block)TFCBlocks.UNSTAINED_WATTLE.get()).m_152465_(lookState);
        }
        return super.getStateToDraw(level, player, lookState, direction, lookPos, x, y, z, item);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (this.getFluidProperty().canContain(fluidState.m_76152_())) {
            return (BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return this.m_49966_();
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{WOVEN, this.getFluidProperty()}));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)WOVEN) != false ? super.m_5939_(state, level, pos, context) : Shapes.m_83040_();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WOVEN) != false ? super.m_7952_(state, level, pos) : Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        super.m_142072_(level, state, pos, entity, distance);
        if (distance > 3.0f) {
            level.m_46961_(pos, true);
        }
    }
}

