/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Random;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCLightBlock
extends Block
implements IFluidLoggable {
    public static final int MAX_LEVEL = 15;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;

    public TFCLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(15))).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        CompoundTag tag = context.m_43722_().m_41783_();
        if (tag != null && tag.m_128425_("level", 3)) {
            state = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(tag.m_128451_("level")));
        }
        return state;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (rand.nextInt(20) == 0) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL, FLUID});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!player.m_7500_()) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)LEVEL), 2);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return ctx.m_7142_(this.m_5456_()) ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState faceState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, faceState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("level", ((Integer)state.m_61143_((Property)LEVEL)).intValue());
        return stack;
    }
}

